# Guides


:::{toctree}
:maxdepth: 2
:hidden:

why-use-nemo-run
configuration
execution
management
ray
cli
:::

Welcome to the NeMo-Run guides! This section provides comprehensive documentation on how to use NeMo-Run effectively for your machine learning experiments.

## Get Started

If you're new to NeMo-Run, we recommend starting with:

- **[Why Use NeMo-Run?](why-use-nemo-run.md)** - Understand the benefits and philosophy behind NeMo-Run.
- **[Configuration](configuration.md)** - Learn how to configure your ML tasks and experiments.
- **[Execution](execution.md)** - Discover how to run your experiments across different computing environments.
- **[Management](management.md)** - Master experiment tracking, reproducibility, and organization.

## Advanced Topics

For more advanced usage:

- **[Ray Integration](ray.md)** - Learn how to use NeMo-Run with Ray for distributed computing.
- **[CLI Reference](cli.md)** - Explore the command-line interface for NeMo-Run.

## Core Concepts

NeMo-Run is built around three core responsibilities:

1. **Configuration** - Define your ML experiments using a flexible, Pythonic configuration system.
1. **Execution** - Run your experiments seamlessly across local machines, Slurm clusters, cloud providers, and more.
1. **Management** - Track, reproduce, and organize your experiments with built-in experiment management.

Each guide dives deep into these concepts with practical examples and best practices. Choose a guide above to get started!
