#!/bin/bash
#
# Generated by NeMo Run
# Run with: cmd1 cmd2
#

# Parameters
#SBATCH --account=account
#SBATCH --job-name=account-account.sample_job-0
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=8
#SBATCH --open-mode=append
#SBATCH --output=/root/experiment/sample_job/sbatch_account-account.sample_job-0_%j.out
#SBATCH --time=00:10:00
#SBATCH hetjob
#SBATCH --account=account
#SBATCH --job-name=account-account.sample_job-1
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --open-mode=append
#SBATCH --output=/root/experiment/sample_job/sbatch_account-account.sample_job-1_%j.out
#SBATCH --time=00:10:00

set -evx

export PYTHONUNBUFFERED=1
export SLURM_UNBUFFEREDIO=1
export TORCHX_MAX_RETRIES=3

set +e

# setup

nodes=( $( scontrol show hostnames $SLURM_JOB_NODELIST ) )
nodes_array=($nodes)
head_node=${nodes_array[0]}
head_node_ip=$(srun --nodes=1 --ntasks=1 -w "$head_node" hostname --ip-address)


het_group_host_0=$(scontrol show hostnames=$SLURM_JOB_NODELIST_HET_GROUP_0 | head -n1)
het_group_host_1=$(scontrol show hostnames=$SLURM_JOB_NODELIST_HET_GROUP_1 | head -n1)

export ENV_VAR=value
# This script uses experimental fault tolerance launcher
# Fault tolerance related items
export FAULT_TOL_CFG_PATH="/root/experiment/sample_job/sample_job_ft_cfg.yml"
export FAULT_TOL_FINISHED_FLAG_FILE="/nemo_run/sample_job_finished_flag"
ANY_JOB_STEP_FAILED=0

# Automatic job resubmission related items
JOB_RESULTS_FILE="/root/experiment/sample_job/sample_job_job_results"
is_job_failures_limit_reached() {
    if [ $TORCHX_MAX_RETRIES -eq 0 ]; then
       true
    else
        tail -n $TORCHX_MAX_RETRIES "$JOB_RESULTS_FILE" | \
            awk "/^[[:alnum:]]+[[:space:]]+[[:alnum:]]+[[:space:]]+[XF]$/{f++} END{exit !(f>=$TORCHX_MAX_RETRIES)}"
    fi
}
is_training_finished() {
    test -f "$(dirname $JOB_RESULTS_FILE)/$(basename $FAULT_TOL_FINISHED_FLAG_FILE)"
}
# Exit immediately if finished flag file exists and this job is a continuation
if [ -v SLURM_RESTART_COUNT ] && [ "$SLURM_RESTART_COUNT" -gt 0 ] ; then
    if is_training_finished ; then echo "Training is finished" ; exit 0 ; fi
    if is_job_failures_limit_reached ; then echo "Job failures limit reached ($TORCHX_MAX_RETRIES)" ; exit 1 ; fi
else
    rm -f "$FAULT_TOL_FINISHED_FLAG_FILE" "$JOB_RESULTS_FILE"
fi

# Write unknown job status to the job log, we will fix it at the end
echo "$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} X" >> "$JOB_RESULTS_FILE"


# Command 1

export CUSTOM_ENV_1=some_value_1


srun --het-group=0 --output /root/experiment/sample_job/log-account-account.sample_job-0_%j_${SLURM_RESTART_COUNT:-0}.out --container-image image_1 --container-mounts /root/experiment/sample_job:/nemo_run --container-workdir /nemo_run/code --wait=60 --kill-on-bad-exit=1 ft_launcher --ft-param-workload_check_interval 10 --ft-param-rank_heartbeat_timeout 10 --rdzv-backend c10d --rdzv-endpoint localhost:0 --rdzv-id 1 --nnodes 1 --nproc-per-node 1 --node-rank 0 --tee 3 --no-python test_ft.sh & pids[0]=$!

sleep 30


# Command 2

export CUSTOM_ENV_2=some_value_2

export HOST_1=$het_group_host_0


srun --het-group=1 --output /root/experiment/sample_job/log-account-account.sample_job-1_%j_${SLURM_RESTART_COUNT:-0}.out --container-image image_2 --container-mounts /root/experiment/sample_job:/nemo_run --container-workdir /nemo_run/code --wait=60 --kill-on-bad-exit=1 bash ./scripts/echo.sh server_host=$het_group_host_0 & pids[1]=$!


# The code below monitors all SLURM jobs to ensure any failure forces them all to stop
# (otherwise some jobs may remain pending until they reach the cluster time limit).
all_done=false
while ! $all_done; do
    all_done=true
    for pid in "${pids[@]}"; do
        if ps -p "$pid" > /dev/null; then
            # Process is still running.
            all_done=false
        else
            # Process is no longer running => check its exit status.
            wait "$pid"
            exitcode=$?
            echo "Process $pid exited with code $exitcode at $(date '+%Y-%m-%d %H:%M:%S')"
            # Wait a bit (to get a clean stack trace in case there is one being generated), then kill the
            # remaining processes if needed.
            sleep 60
            for other_pid in "${pids[@]}"; do
                if ps -p "$other_pid" > /dev/null; then
                    echo "Killing process $other_pid"
                    kill -9 "$other_pid"
                fi
            done
            break 2
        fi
    done

    # Sleep for a while before checking again.
    sleep 60
done

set -e

echo "job exited with code $exitcode"
if [ $exitcode -ne 0 ]; then ANY_JOB_STEP_FAILED=1 ; fi
# Fix the job log entry ("JOB_ID X" -> "JOB_ID S/F"), depending on the job result
if [ "$ANY_JOB_STEP_FAILED" = "0" ] ; then
   sed -i "s/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} X/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} S/" "$JOB_RESULTS_FILE"
else
   sed -i "s/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} X/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} F/" "$JOB_RESULTS_FILE"
fi

if ! (is_training_finished || is_job_failures_limit_reached); then
    scontrol requeue "$SLURM_JOB_ID"
    exit $exitcode
fi
