#!/bin/bash
#
# Generated by NeMo Run
# Run with: cmd1 cmd2
#

# Parameters
#SBATCH --account=account
#SBATCH --job-name=account-account.sample_job
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --open-mode=append
#SBATCH --output=/root/sample_job/sbatch_account-account.sample_job_%j.out
#SBATCH --time=00:10:00

set -evx

export PYTHONUNBUFFERED=1
export SLURM_UNBUFFEREDIO=1
export TORCHX_MAX_RETRIES=3

set +e

# setup

nodes=( $( scontrol show hostnames $SLURM_JOB_NODELIST ) )
nodes_array=($nodes)
head_node=${nodes_array[0]}
head_node_ip=$(srun --nodes=1 --ntasks=1 -w "$head_node" hostname --ip-address)

export ENV_VAR=value
# This script uses experimental fault tolerance launcher
# Fault tolerance related items
export FAULT_TOL_CFG_PATH="/root/sample_job/sample_job_ft_cfg.yml"
export FAULT_TOL_FINISHED_FLAG_FILE="/nemo_run/sample_job_finished_flag"
ANY_JOB_STEP_FAILED=0

# Automatic job resubmission related items
JOB_RESULTS_FILE="/root/sample_job/sample_job_job_results"
is_job_failures_limit_reached() {
    if [ $TORCHX_MAX_RETRIES -eq 0 ]; then
       true
    else
        tail -n $TORCHX_MAX_RETRIES "$JOB_RESULTS_FILE" | \
            awk "/^[[:alnum:]]+[[:space:]]+[[:alnum:]]+[[:space:]]+[XF]$/{f++} END{exit !(f>=$TORCHX_MAX_RETRIES)}"
    fi
}
is_training_finished() {
    test -f "$(dirname $JOB_RESULTS_FILE)/$(basename $FAULT_TOL_FINISHED_FLAG_FILE)"
}
# Exit immediately if finished flag file exists and this job is a continuation
if [ -v SLURM_RESTART_COUNT ] && [ "$SLURM_RESTART_COUNT" -gt 0 ] ; then
    if is_training_finished ; then echo "Training is finished" ; exit 0 ; fi
    if is_job_failures_limit_reached ; then echo "Job failures limit reached ($TORCHX_MAX_RETRIES)" ; exit 1 ; fi
else
    rm -f "$FAULT_TOL_FINISHED_FLAG_FILE" "$JOB_RESULTS_FILE"
fi

# Write unknown job status to the job log, we will fix it at the end
echo "$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} X" >> "$JOB_RESULTS_FILE"


# Command 1

srun --output /root/sample_job/log-account-account.sample_job_%j_${SLURM_RESTART_COUNT:-0}.out --container-mounts /root/sample_job:/nemo_run --container-workdir /nemo_run/code --wait=60 --kill-on-bad-exit=1 ft_launcher --ft-param-workload_check_interval 10 --ft-param-rank_heartbeat_timeout 10 --rdzv-backend c10d --rdzv-endpoint localhost:0 --rdzv-id 7680 --nnodes 1 --nproc-per-node 1 --node-rank 0 --tee 3 --no-python test_ft.sh

exitcode=$?

set -e

echo "job exited with code $exitcode"
if [ $exitcode -ne 0 ]; then ANY_JOB_STEP_FAILED=1 ; fi
# Fix the job log entry ("JOB_ID X" -> "JOB_ID S/F"), depending on the job result
if [ "$ANY_JOB_STEP_FAILED" = "0" ] ; then
   sed -i "s/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} X/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} S/" "$JOB_RESULTS_FILE"
else
   sed -i "s/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} X/$SLURM_JOB_ID ${SLURM_RESTART_COUNT:-0} F/" "$JOB_RESULTS_FILE"
fi

if ! (is_training_finished || is_job_failures_limit_reached); then
    scontrol requeue "$SLURM_JOB_ID"
    exit $exitcode
fi
