#!/bin/bash
#
# Generated by NeMo Run
# Run with: sbatch --parsable
#

# Parameters
#SBATCH --account=your_account
#SBATCH --gpus-per-node=8
#SBATCH --job-name=your_account-account.sample_job-0
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=8
#SBATCH --open-mode=append
#SBATCH --output=/some/job/dir/sample_job/sbatch_your_account-account.sample_job-0_%j.out
#SBATCH --partition=your_partition
#SBATCH --time=00:30:00

set -evx

export PYTHONUNBUFFERED=1
export SLURM_UNBUFFEREDIO=1
export TORCHX_MAX_RETRIES=3

set +e

# setup

nodes=( $( scontrol show hostnames $SLURM_JOB_NODELIST ) )
nodes_array=($nodes)
head_node=${nodes_array[0]}
head_node_ip=$(srun --nodes=1 --ntasks=1 -w "$head_node" hostname --ip-address)

export CUSTOM_ENV_1=some_value_1
export ENV_VAR=value


# Command 1

export CUSTOM_ENV_1=some_value_1


srun --output /some/job/dir/sample_job/log-your_account-account.sample_job-0_%j_${SLURM_RESTART_COUNT:-0}.out --container-image some-image --container-mounts /some/job/dir/sample_job:/nemo_run --container-workdir /nemo_run/code --wait=60 --kill-on-bad-exit=1 bash ./scripts/start_server.sh & pids[0]=$!

sleep 10


# Command 2

export CUSTOM_ENV_1=some_value_1


srun --output /some/job/dir/sample_job/log-your_account-account.sample_job-1_%j_${SLURM_RESTART_COUNT:-0}.out --container-image different_container_image --container-mounts /some/job/dir/sample_job:/nemo_run --container-workdir /nemo_run/code --wait=60 --kill-on-bad-exit=1 --mpi=pmix bash ./scripts/echo.sh server_host=$het_group_host_0 & pids[1]=$!


# The code below monitors all SLURM jobs to ensure any failure forces them all to stop
# (otherwise some jobs may remain pending until they reach the cluster time limit).
all_done=false
while ! $all_done; do
    all_done=true
    for pid in "${pids[@]}"; do
        if ps -p "$pid" > /dev/null; then
            # Process is still running.
            all_done=false
        else
            # Process is no longer running => check its exit status.
            wait "$pid"
            exitcode=$?
            echo "Process $pid exited with code $exitcode at $(date '+%Y-%m-%d %H:%M:%S')"
            # Wait a bit (to get a clean stack trace in case there is one being generated), then kill the
            # remaining processes if needed.
            sleep 60
            for other_pid in "${pids[@]}"; do
                if ps -p "$other_pid" > /dev/null; then
                    echo "Killing process $other_pid"
                    kill -9 "$other_pid"
                fi
            done
            break 2
        fi
    done

    # Sleep for a while before checking again.
    sleep 60
done

set -e

echo "job exited with code $exitcode"
if [ $exitcode -ne 0 ]; then
    if [ "$TORCHX_MAX_RETRIES" -gt "${SLURM_RESTART_COUNT:-0}" ]; then
        scontrol requeue "$SLURM_JOB_ID"
    fi
    exit $exitcode
fi
