# Task-Persona Mapping Guide

## Purpose
This document maps different types of tasks to the most appropriate advanced company personas based on skill requirements, expertise, and organizational roles.

## Executive & Management Tasks

### Strategic & Architectural Tasks
**Assigned to**: Chief Technology Officer (CTO), Engineering Manager (EM)

#### Technology Strategy
- Define long-term technology strategy aligned with business objectives
- Evaluate and approve complex architectural decisions
- Drive technical innovation and emerging technology adoption
- Assess and mitigate enterprise-level technical risks
- Establish enterprise technical standards and frameworks

#### Resource Allocation
- Lead high-performing engineering teams and career development
- Strategically plan and execute large-scale projects
- Optimize organizational processes and efficiency
- Drive technical and cultural initiatives across teams

### Project Management Tasks
**Assigned to**: Engineering Manager (EM), Project Manager (PJ)

#### Strategic Project Planning & Oversight
- Lead complex programs and portfolios of projects
- Manage strategic stakeholder relationships and executive engagement
- Develop and execute advanced risk management strategies
- Drive organizational change and process improvement

#### Team Management
- Strategically plan and execute large-scale projects
- Optimize organizational processes and efficiency
- Drive technical and cultural initiatives across teams
- Plan strategic team development and career advancement

### Product Management Tasks
**Assigned to**: Product Manager (PM)

#### Advanced Requirements & Prioritization
- Define and execute advanced product strategy and roadmap
- Analyze market data and competitive landscape to inform product decisions
- Establish key product metrics and success indicators
- Drive strategic stakeholder alignment and executive buy-in

#### Strategic Stakeholder Communication
- Analyze market data and competitive landscape to inform product decisions
- Drive strategic stakeholder alignment and executive buy-in
- Establish key product metrics and success indicators
- Coordinate complex product initiatives across multiple teams

## Design Tasks

### Advanced User Experience Tasks
**Assigned to**: UX Designer (UX), Product Manager (PM)

#### Advanced User Research & Analysis
- Conduct advanced user research and behavioral analysis
- Design complex system architectures and interaction patterns
- Create advanced prototypes and conduct usability testing
- Develop comprehensive user journey maps and experience strategies

#### Information Architecture
- Design complex system architectures and interaction patterns
- Create advanced prototypes and conduct usability testing
- Develop comprehensive user journey maps and experience strategies
- Establish design principles and interaction guidelines

### Advanced User Interface Tasks
**Assigned to**: UI Designer (UI), UX Designer (UX)

#### Advanced Visual Design
- Create advanced visual design systems and brand implementations
- Develop and maintain comprehensive design systems
- Establish and maintain visual design standards and guidelines
- Create advanced interactive prototypes and animations

#### Design System Architecture
- Develop and maintain comprehensive design systems
- Establish and maintain visual design standards and guidelines
- Create advanced interactive prototypes and animations
- Ensure accessibility and inclusive design compliance

## Development Tasks

### Advanced Backend Tasks
**Assigned to**: Backend Developer (BE), Full-Stack Developer (FS)

#### Enterprise Database Operations
- Design and implement advanced server architectures and distributed systems
- Create optimized database schemas and complex data models
- Architect scalable API systems and microservices
- Implement advanced authentication and authorization systems

#### Advanced API Architecture
- Architect scalable API systems and microservices
- Design complex API ecosystems and integration patterns
- Implement enterprise-level security and compliance
- Optimize performance and scalability at scale

#### Complex Server-Side Systems
- Design and implement complex server architectures and distributed systems
- Implement complex business logic and algorithms
- Architect scalable, resilient systems
- Design enterprise-level security and compliance measures

### Advanced Frontend Tasks
**Assigned to**: Frontend Developer (FE), Full-Stack Developer (FS)

#### Advanced UI Architecture
- Architect and implement complex frontend systems and state management
- Create optimized performance and user experience across all devices
- Handle complex client-side business logic and data flows
- Implement comprehensive security and accessibility compliance

#### Performance & Optimization
- Optimize performance and user experience across all devices
- Implement advanced UI components and design systems
- Handle complex client-side business logic and data flows
- Ensure accessibility and security compliance

### Infrastructure & Operations Tasks
**Assigned to**: DevOps Engineer (DO), Engineering Manager (EM)

#### Enterprise Infrastructure
- Design and implement enterprise-scale cloud infrastructure
- Create advanced CI/CD pipelines and deployment automation
- Implement comprehensive monitoring and observability systems
- Establish security and compliance frameworks

#### Advanced Operations
- Create advanced CI/CD pipelines and deployment automation
- Implement comprehensive monitoring and observability systems
- Establish security and compliance frameworks
- Optimize performance and capacity planning

### Security Tasks
**Assigned to**: Security Specialist (SEC), Backend Developer (BE)

#### Enterprise Security Architecture
- Design and implement enterprise security architectures
- Conduct advanced vulnerability assessments and penetration testing
- Implement comprehensive authentication and authorization systems
- Design and implement advanced data protection and encryption

#### Compliance & Standards
- Conduct advanced vulnerability assessments and penetration testing
- Implement comprehensive authentication and authorization systems
- Design and implement advanced data protection and encryption
- Ensure compliance with security standards and regulations

### Quality Assurance Tasks
**Assigned to**: QA Engineer (QA), Full-Stack Developer (FS), Product Manager (PM)

#### Advanced Testing Strategy
- Design and implement comprehensive test strategies
- Create advanced automated test frameworks and suites
- Perform complex performance and load testing
- Analyze and report on quality metrics and trends

#### Quality Validation
- Create advanced automated test frameworks and suites
- Perform complex performance and load testing
- Analyze and report on quality metrics and trends
- Manage complex test environments and data

### Data-Related Tasks
**Assigned to**: Data Engineer (DE), Backend Developer (BE)

#### Enterprise Data Architecture
- Design and implement enterprise data architectures
- Create complex ETL and real-time data processing systems
- Architect data warehouses and analytical systems
- Implement data quality and governance frameworks

#### Advanced Data Processing
- Create complex ETL and real-time data processing systems
- Architect data warehouses and analytical systems
- Implement data quality and governance frameworks
- Design machine learning data pipelines and feature stores

### Mobile Tasks
**Assigned to**: Mobile Developer (MOB), Full-Stack Developer (FS)

#### Advanced Mobile Architecture
- Design and implement advanced mobile system architectures
- Create high-performance cross-platform solutions
- Implement complex mobile-specific security and data handling
- Optimize for performance, battery, and network usage

#### Mobile Platform Strategy
- Create high-performance cross-platform solutions
- Implement complex mobile-specific security and data handling
- Optimize for performance, battery, and network usage
- Manage app store deployments and user acquisition

## Operations & Support Tasks

### Advanced Documentation Tasks
**Assigned to**: Technical Writer (TW), Full-Stack Developer (FS), UX Designer (UX)

#### Documentation Strategy & Architecture
- Design and implement comprehensive documentation strategies
- Architect complex documentation systems and information flows
- Create advanced API and developer documentation
- Manage knowledge management and content systems

#### Knowledge Management
- Architect complex documentation systems and information flows
- Create advanced API and developer documentation
- Manage knowledge management and content systems
- Ensure content accessibility and localization

### Business Analysis Tasks
**Assigned to**: Business Analyst (BA), Product Manager (PM)

#### Advanced Requirements Analysis
- Conduct advanced business analysis and requirements engineering
- Design complex process models and optimization strategies
- Validate business solutions against strategic objectives
- Create and maintain business intelligence and reporting

#### Strategic Process Management
- Design complex process models and optimization strategies
- Manage stakeholder relationships and change initiatives
- Validate business solutions against strategic objectives
- Create and maintain business intelligence and reporting

## General Assignment Rules

### When Multiple Personas Qualify
When a task could be assigned to multiple personas:
1. Prioritize by primary specialization (e.g., backend task → Backend Developer)
2. Consider organizational hierarchy (e.g., strategic decisions → management roles)
3. Evaluate workload distribution and availability
4. Factor in individual expertise levels and specializations
5. Account for project complexity and risk factors

### Cross-Functional Tasks
For tasks requiring expertise from multiple organizational areas:
- Identify the primary organizational role needed based on task complexity
- Assign to the most relevant senior persona
- Facilitate collaboration with other specialists as needed
- Consider forming cross-functional teams for complex enterprise tasks

### Decision-Making Hierarchy
For tasks involving strategic decisions:
1. Individual contributor implementation → Developers
2. Technical architecture decisions → Senior Developers, Architects
3. Cross-team technical decisions → Engineering Manager, DevOps
4. Strategic technical decisions → CTO, Engineering Manager
5. Business and product decisions → Product Manager, Business Analyst
6. Enterprise-level decisions → CTO, Engineering Manager, Project Manager

## Task Assignment Process

1. **Identify Task Complexity**: Determine the level of expertise and specialization required for the task
2. **Match Persona**: Use the mappings above to identify the appropriate advanced persona(s)
3. **Consider Specialization**: Factor in specific technologies, organizational needs, or advanced requirements
4. **Account for Availability**: Check senior team member workload and availability
5. **Make Assignment**: Assign to the most appropriate available advanced team member
6. **Plan Collaboration**: Identify additional senior personas needed for support or review