"""Data models describing pipeline configuration and results."""

from __future__ import annotations

from dataclasses import dataclass
from pathlib import Path
from typing import Optional


@dataclass(frozen=True)
class ProcessingOptions:
    """Configuration values controlling how the talks reducer processes media.

    The fields map 1:1 to the command line options exposed by the CLI so the
    same configuration can be shared between user interfaces.
    """

    input_file: Path
    output_file: Optional[Path] = None
    frame_rate: float = 30.0
    sample_rate: int = 44100
    silent_threshold: float = 0.03
    silent_speed: float = 4.0
    sounded_speed: float = 1.0
    frame_spreadage: int = 2
    audio_fade_envelope_size: int = 400
    temp_folder: Path = Path("TEMP")
    small: bool = False


@dataclass(frozen=True)
class ProcessingResult:
    """Summary of the metadata generated by a successful pipeline execution."""

    input_file: Path
    output_file: Path
    frame_rate: float
    original_duration: float
    chunk_count: int
    used_cuda: bool
    max_audio_volume: float
