# generated by datamodel-codegen:
#   filename:  api/data/createQuery.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference, tagLabel


class CreateQueryRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[basic.EntityName] = Field(
        None, description='Name of a Query in case of User Creation.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this query.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the query instance.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this entity'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Query'
    )
    query: basic.SqlQuery = Field(..., description='SQL Query definition.')
    duration: Optional[float] = Field(
        None, description='How long did the query took to run in seconds.'
    )
    users: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None, description='UserName of the user running the query.'
    )
    queryDate: Optional[basic.Timestamp] = Field(
        None, description='Date on which the query ran.'
    )
    queryUsedIn: Optional[entityReference.EntityReferenceList] = Field(
        None, description='list of entities to which the query is joined.'
    )
