# generated by datamodel-codegen:
#   filename:  entity/data/dashboardDataModel.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, tagLabel
from ..services import dashboardService
from . import table


class DataModelType(Enum):
    TableauDataModel = 'TableauDataModel'
    SupersetDataModel = 'SupersetDataModel'
    MetabaseDataModel = 'MetabaseDataModel'
    LookMlView = 'LookMlView'
    LookMlExplore = 'LookMlExplore'


class DashboardDataModel(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this data model instance.'
    )
    name: basic.EntityName = Field(
        ...,
        description='Name of a data model. Expected to be unique within a Dashboard.',
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this data model. It could be title or label from the source.',
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='Fully qualified name of a data model in the form `serviceName.dashboardName.datamodel.datamodelName`.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a data model.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to this data model entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this data model.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this data model.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    followers: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Followers of this dashboard.'
    )
    service: Optional[entityReference.EntityReference] = Field(
        None, description='Link to service where this data model is hosted in.'
    )
    serviceType: Optional[dashboardService.DashboardServiceType] = Field(
        None, description='Service type where this data model is hosted in.'
    )
    dataModelType: DataModelType
    sql: Optional[basic.SqlQuery] = Field(
        None, description='In case the Data Model is based on a SQL query.'
    )
    columns: List[table.Column] = Field(..., description='Columns from the data model.')
    dataModels: Optional[entityReference.EntityReferenceList] = Field(
        None, description='List of data models used by this data model.'
    )
