# generated by datamodel-codegen:
#   filename:  entity/events/webhook.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr


class Webhook(BaseModel):
    class Config:
        extra = Extra.forbid

    endpoint: Optional[AnyUrl] = Field(
        None, description='Endpoint to receive the webhook events over POST requests.'
    )
    secretKey: Optional[str] = Field(
        None,
        description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
    )
    sendToAdmins: Optional[bool] = Field(False, description='Send the Event to Admins')
    sendToOwners: Optional[bool] = Field(False, description='Send the Event to Owners')
    sendToFollowers: Optional[bool] = Field(
        False, description='Send the Event to Followers'
    )


class EntityName(BaseModel):
    __root__: constr(regex=r'^(?u)[\w\'\-.]+$', min_length=1, max_length=128) = Field(
        ..., description='Unique name of the application receiving webhook events.'
    )
