# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/oracleConnection.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class OracleType(Enum):
    Oracle = 'Oracle'


class OracleScheme(Enum):
    oracle_cx_oracle = 'oracle+cx_oracle'


class OracleDatabaseSchema(BaseModel):
    databaseSchema: str = Field(
        ...,
        description='databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.',
        title='DatabaseSchema',
    )


class OracleServiceName(BaseModel):
    oracleServiceName: str = Field(
        ...,
        description='The Oracle Service name is the TNS alias that you give when you remotely connect to your database.',
        title='Oracle Service Name',
    )


class OracleConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[OracleType] = Field(
        OracleType.Oracle, description='Service Type', title='Service Type'
    )
    scheme: Optional[OracleScheme] = Field(
        OracleScheme.oracle_cx_oracle,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Oracle. This user should have privileges to read all the metadata in Oracle.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to Oracle.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Oracle service.', title='Host and Port'
    )
    oracleConnectionType: Union[OracleDatabaseSchema, OracleServiceName] = Field(
        ...,
        description='Connect with oracle by either passing service name or database schema name.',
        title='Oracle Connection Type',
    )
    instantClientDirectory: Optional[str] = Field(
        '/instantclient',
        description='This directory will be used to set the LD_LIBRARY_PATH env variable. It is required if you need to enable thick connection mode. By default, we bring instant client 19 and point to /instantclient.',
        title='Oracle instant client directory',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
