# generated by datamodel-codegen:
#   filename:  entity/services/connections/testConnectionDefinition.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ....type import basic, entityHistory, entityReference


class TestConnectionStep(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name of the step being tested')
    description: str = Field(..., description='What is the goal of the step')
    errorMessage: Optional[str] = Field(
        None,
        description='In case of error this message should be displayed on UI, We define this message manually on test connection definition',
    )
    mandatory: bool = Field(..., description='Is this step mandatory to be passed?')
    shortCircuit: Optional[bool] = Field(
        False,
        description='This field if set to true, indicates that the step is important enough to break the process in case of failure.',
    )


class TestConnectionDefinition(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this test case definition instance.'
    )
    name: basic.EntityName = Field(
        ...,
        description='Name of the Test Connection Definition. It should be the `type` of the service being tested, e.g., Mysql, or Snowflake.',
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this test definition.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the test connection def.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    steps: List[TestConnectionStep] = Field(
        ..., description='Steps to test the connection. Order matters.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this TestConnection definition.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
