# generated by datamodel-codegen:
#   filename:  entity/services/connections/testConnectionResult.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ....type import basic


class TestConnectionStepResult(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name of the step being tested')
    mandatory: bool = Field(..., description='Is this step mandatory to be passed?')
    passed: bool = Field(..., description='Did the step pass successfully?')
    message: Optional[str] = Field(
        None,
        description='Results or exceptions to be shared after running the test. This message comes from the test connection definition',
    )
    errorLog: Optional[str] = Field(
        None,
        description='In case of failed step, this field would contain the actual error faced during the step.',
    )


class StatusType(Enum):
    Successful = 'Successful'
    Failed = 'Failed'
    Running = 'Running'


class TestConnectionResult(BaseModel):
    class Config:
        extra = Extra.forbid

    lastUpdatedAt: Optional[basic.Timestamp] = Field(
        None, description='Last time that the test connection was executed'
    )
    status: Optional[StatusType] = Field(
        None, description='Test Connection Result computation status.'
    )
    steps: List[TestConnectionStepResult] = Field(
        ..., description='Steps to test the connection. Order matters.'
    )
