# generated by datamodel-codegen:
#   filename:  entity/services/ingestionPipelines/ingestionPipeline.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ....metadataIngestion import workflow
from ....type import basic, entityHistory, entityReference
from ..connections.metadata import openMetadataConnection


class PipelineType(Enum):
    metadata = 'metadata'
    usage = 'usage'
    lineage = 'lineage'
    profiler = 'profiler'
    TestSuite = 'TestSuite'
    dataInsight = 'dataInsight'
    elasticSearchReindex = 'elasticSearchReindex'
    dbt = 'dbt'


class PipelineState(Enum):
    queued = 'queued'
    success = 'success'
    failed = 'failed'
    running = 'running'
    partialSuccess = 'partialSuccess'


class PipelineStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    runId: Optional[str] = Field(None, description='Pipeline unique run ID.')
    pipelineState: Optional[PipelineState] = Field(
        None, description='Pipeline status denotes if its failed or succeeded.'
    )
    startDate: Optional[basic.Timestamp] = Field(
        None, description='startDate of the pipeline run for this particular execution.'
    )
    timestamp: Optional[basic.Timestamp] = Field(
        None,
        description='executionDate of the pipeline run for this particular execution.',
    )
    endDate: Optional[basic.Timestamp] = Field(
        None, description='endDate of the pipeline run for this particular execution.'
    )


class AirflowConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    pausePipeline: Optional[bool] = Field(
        False,
        description='pause the pipeline from running once the deploy is finished successfully.',
    )
    concurrency: Optional[int] = Field(1, description='Concurrency of the Pipeline.')
    startDate: Optional[basic.DateTime] = Field(
        None, description='Start date of the pipeline.'
    )
    endDate: Optional[basic.DateTime] = Field(
        None, description='End Date of the pipeline.'
    )
    pipelineTimezone: Optional[str] = Field(
        'UTC', description='Timezone in which pipeline going to be scheduled.'
    )
    retries: Optional[int] = Field(3, description='Retry pipeline in case of failure.')
    retryDelay: Optional[int] = Field(
        300, description='Delay between retries in seconds.'
    )
    pipelineCatchup: Optional[bool] = Field(
        False, description='Run past executions if the start date is in the past.'
    )
    scheduleInterval: Optional[str] = Field(
        None, description='Scheduler Interval for the pipeline in cron format.'
    )
    maxActiveRuns: Optional[int] = Field(
        1, description='Maximum Number of active runs.'
    )
    workflowTimeout: Optional[int] = Field(
        None, description='Timeout for the workflow in seconds.'
    )
    workflowDefaultView: Optional[str] = Field(
        'tree', description='Default view in Airflow.'
    )
    workflowDefaultViewOrientation: Optional[str] = Field(
        'LR', description='Default view Orientation in Airflow.'
    )
    email: Optional[basic.Email] = Field(
        None, description='Email to notify workflow status.'
    )


class IngestionPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this pipeline.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this pipeline instance uniquely.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this Pipeline.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the Pipeline.'
    )
    pipelineType: PipelineType
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Name that uniquely identifies a Pipeline.'
    )
    sourceConfig: workflow.SourceConfig
    openMetadataServerConnection: Optional[
        openMetadataConnection.OpenMetadataConnection
    ] = None
    airflowConfig: AirflowConfig
    service: Optional[entityReference.EntityReference] = Field(
        None,
        description='Link to the database service where this database is hosted in.',
    )
    pipelineStatuses: Optional[PipelineStatus] = Field(
        None, description='Last of executions and status for the Pipeline.'
    )
    loggerLevel: Optional[workflow.LogLevels] = Field(
        workflow.LogLevels.INFO, description='Set the logging level for the workflow.'
    )
    deployed: Optional[bool] = Field(
        False,
        description='Indicates if the workflow has been successfully deployed to Airflow.',
    )
    enabled: Optional[bool] = Field(
        True,
        description='True if the pipeline is ready to be run in the next schedule. False if it is paused.',
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to this ingestion pipeline resource.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
