# generated by datamodel-codegen:
#   filename:  entity/services/storageService.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, tagLabel
from .connections import testConnectionResult
from .connections.storage import s3Connection


class StorageServiceType(Enum):
    S3 = 'S3'
    CustomStorage = 'CustomStorage'


class StorageConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[s3Connection.S3Connection] = None


class StorageService(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of this storage service instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this storage service.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this storage service.'
    )
    serviceType: StorageServiceType = Field(
        ..., description='Type of storage service such as S3, GCS, AZURE...'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a storage service instance.'
    )
    connection: Optional[StorageConnection] = None
    pipelines: Optional[entityReference.EntityReferenceList] = Field(
        None,
        description='References to pipelines deployed for this storage service to extract metadata, usage, lineage etc..',
    )
    testConnectionResult: Optional[testConnectionResult.TestConnectionResult] = Field(
        None, description='Last test connection results for this service'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this storage Service.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this storage service.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this storage service.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
