# generated by datamodel-codegen:
#   filename:  security/client/samlSSOClientConfig.json
#   timestamp: 2023-06-19T13:22:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field


class Idp(BaseModel):
    class Config:
        extra = Extra.forbid

    entityId: str = Field(
        ...,
        description='Identity Provider Entity ID usually same as the SSO login URL.',
    )
    ssoLoginUrl: str = Field(..., description='SSO Login URL.')
    idpX509Certificate: Optional[str] = Field(None, description='X509 Certificate ')
    authorityUrl: Optional[str] = Field(
        None, description='Authority URL to redirect the users on Sign In page'
    )
    nameId: Optional[str] = Field(
        'urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress',
        description='Authority URL to redirect the users on Sign In page',
    )


class Sp(BaseModel):
    class Config:
        extra = Extra.forbid

    entityId: str = Field(..., description='Service Provider Entity ID.')
    acs: str = Field(..., description='Assertion Consumer URL.')
    spX509Certificate: Optional[str] = Field(None, description='X509 Certificate ')
    spPrivateKey: Optional[str] = Field(
        None, description='Sp Private Key for Signing and Encryption Only'
    )
    callback: str = Field(
        ..., description='Service Provider Entity ID usually same as the SSO login URL.'
    )


class Security(BaseModel):
    class Config:
        extra = Extra.forbid

    strictMode: Optional[bool] = Field(
        False,
        description='Only accept valid signed and encrypted assertions if the relevant flags are set',
    )
    tokenValidity: Optional[int] = Field(
        '3600', description='Validity for the JWT Token created from SAML Response'
    )
    sendEncryptedNameId: Optional[bool] = Field(
        False, description='Encrypt Name Id while sending requests from SP.'
    )
    sendSignedAuthRequest: Optional[bool] = Field(
        False, description='Sign the Authn Request while sending.'
    )
    signSpMetadata: Optional[bool] = Field(
        False, description='Want the Metadata of this SP to be signed.'
    )
    wantMessagesSigned: Optional[bool] = Field(
        False, description='SP requires the messages received to be signed.'
    )
    wantAssertionsSigned: Optional[bool] = Field(
        False, description='SP requires the assertions received to be signed.'
    )
    wantAssertionEncrypted: Optional[bool] = Field(
        False, description='SP requires the assertion received to be encrypted.'
    )
    wantNameIdEncrypted: Optional[bool] = Field(
        False, description='SP requires the Name Id received to be encrypted.'
    )
    keyStoreFilePath: Optional[str] = Field(None, description='KeyStore File Path')
    keyStoreAlias: Optional[str] = Field(None, description='KeyStore Alias')
    keyStorePassword: Optional[str] = Field(None, description='KeyStore Password')


class SamlSSOClientConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    idp: Idp
    sp: Sp
    security: Optional[Security] = None
    debugMode: Optional[bool] = Field(
        False, description='Get logs from the Library in debug mode'
    )
