---
name: Bug Report
about: Create a report to help us improve PuffinFlow
title: '[BUG] '
labels: ['bug', 'needs-triage']
assignees: ''
---

## Bug Description

**Describe the bug**
A clear and concise description of what the bug is.

**Expected behavior**
A clear and concise description of what you expected to happen.

**Actual behavior**
A clear and concise description of what actually happened.

## Reproduction Steps

**To Reproduce**
Steps to reproduce the behavior:
1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error

**Minimal code example**
```python
# Please provide a minimal code example that reproduces the issue
from puffinflow import Agent

# Your code here
```

## Environment Information

**PuffinFlow version:**
<!-- Run: pip show puffinflow -->

**Python version:**
<!-- Run: python --version -->

**Operating System:**
<!-- e.g., Ubuntu 20.04, Windows 10, macOS 12.0 -->

**Installation method:**
- [ ] pip
- [ ] conda
- [ ] from source
- [ ] other (please specify)

**Optional dependencies installed:**
- [ ] observability
- [ ] integrations
- [ ] cli
- [ ] all
- [ ] none

## Additional Context

**Error messages/logs**
```
Paste any error messages or relevant log output here
```

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Stack trace**
```
If there's a stack trace, paste it here
```

**Configuration**
```python
# If relevant, share your configuration
```

**Additional context**
Add any other context about the problem here.

## Checklist

- [ ] I have searched existing issues to ensure this is not a duplicate
- [ ] I have provided a minimal code example that reproduces the issue
- [ ] I have included the PuffinFlow version and Python version
- [ ] I have included relevant error messages or logs
- [ ] I have checked the documentation and this issue is not covered there

## Possible Solution

<!-- Optional: If you have ideas on how to fix this bug, please describe them here -->

## Impact

**Severity:**
- [ ] Critical (blocks core functionality)
- [ ] High (significantly impacts functionality)
- [ ] Medium (some functionality affected)
- [ ] Low (minor issue or cosmetic)

**Frequency:**
- [ ] Always
- [ ] Often
- [ ] Sometimes
- [ ] Rarely

**Workaround available:**
- [ ] Yes (please describe below)
- [ ] No

**Workaround description:**
<!-- If you found a workaround, please describe it here -->
