---
name: Question
about: Ask a question about PuffinFlow usage, concepts, or best practices
title: '[QUESTION] '
labels: ['question', 'needs-triage']
assignees: ''
---

## Question Summary

**What would you like to know?**
A clear and concise description of your question.

**Category**
What type of question is this?
- [ ] Usage/How-to
- [ ] Best practices
- [ ] Architecture/Design
- [ ] Performance
- [ ] Integration
- [ ] Troubleshooting
- [ ] Conceptual understanding
- [ ] Other (please specify)

## Context

**What are you trying to achieve?**
Describe your overall goal or use case.

**What have you tried so far?**
Share any approaches you've attempted or research you've done.

**Code example (if applicable)**
```python
# Share relevant code that you're working with
from puffinflow import Agent

# Your code here
```

**Current behavior**
If you have code that's running but not behaving as expected, describe what's happening.

**Expected or desired behavior**
Describe what you want to happen or what you think should happen.

## Environment Information

**PuffinFlow version:**
<!-- Run: pip show puffinflow -->

**Python version:**
<!-- Run: python --version -->

**Operating System:**
<!-- e.g., Ubuntu 20.04, Windows 10, macOS 12.0 -->

**Optional dependencies:**
Which optional dependencies do you have installed?
- [ ] observability
- [ ] integrations
- [ ] cli
- [ ] all
- [ ] none

## Specific Questions

**Main question:**
<!-- Your primary question here -->

**Follow-up questions:**
<!-- Any related questions you have -->

**Documentation references:**
Have you checked the documentation? If so, which sections?
- [ ] README
- [ ] API documentation
- [ ] Examples
- [ ] Tutorials
- [ ] I couldn't find relevant documentation

**Links to documentation you've read:**
<!-- If you've read specific documentation, link to it here -->

## Additional Context

**Related issues/discussions:**
<!-- Link any related issues or discussions you've found -->

**External resources:**
<!-- Any blog posts, Stack Overflow questions, or other resources you've consulted -->

**Screenshots/diagrams:**
<!-- If visual aids would help explain your question, include them here -->

**Error messages (if any):**
```
Paste any error messages here
```

**Configuration (if relevant):**
```python
# Share your configuration if it's relevant to the question
```

## Community Guidelines

**Research done:**
- [ ] I have searched existing issues and discussions
- [ ] I have read the relevant documentation
- [ ] I have looked at the examples in the repository
- [ ] I have searched online for similar questions

**Question clarity:**
- [ ] My question is specific and focused
- [ ] I have provided sufficient context
- [ ] I have included relevant code examples
- [ ] I have specified my environment details

## Help Us Help You

**Response format preference:**
- [ ] Code example
- [ ] Detailed explanation
- [ ] Links to documentation
- [ ] Step-by-step guide
- [ ] Conceptual overview
- [ ] No preference

**Urgency:**
- [ ] Urgent (blocking my work)
- [ ] High (important for current project)
- [ ] Medium (would like to know soon)
- [ ] Low (general curiosity)

**Follow-up availability:**
- [ ] Available for follow-up questions
- [ ] Limited availability for follow-up
- [ ] Prefer complete answer in first response

## Contribution

**Would you be interested in contributing?**
If we help you solve this problem, would you be interested in:
- [ ] Writing documentation to help others with similar questions
- [ ] Creating an example or tutorial
- [ ] Improving existing documentation
- [ ] Contributing code improvements
- [ ] Just getting my question answered

## Thank You

Thank you for taking the time to ask a thoughtful question! The PuffinFlow community appreciates well-researched questions that help everyone learn.

**Additional notes:**
<!-- Any other information you think might be helpful -->
