# Welcome to PicTex

![PicTex](https://res.cloudinary.com/dlvnbnb9v/image/upload/v1753831765/readme-1_vqnohh.png)

**`PicTex` is a Python library for creating beautifully styled visual compositions.**

Whether you're generating dynamic images for social media, creating video overlays, or building tools for digital art, `PicTex` simplifies the process. It abstracts away the complexity of low-level graphics engines, offering a component-based and chainable interface inspired by modern layout systems.

This documentation will guide you through everything `PicTex` has to offer. You'll learn how to leverage its powerful layout engine to compose elements, how to style them with a flexible box model, and how to export your creations to both raster and vector formats.

## Where to Go Next

Whether you're new to `PicTex` or an experienced user, here's where to find what you need.

-   __Getting Started__

    New to `PicTex`? This is the place to start. Learn the core concepts and create your first image in minutes.

    [Go to Getting Started](./getting_started.md)

-   __Guides__
    
    Ready to build? Our guides will teach you how to compose and style complex visuals. We recommend starting with the Core Concepts.

    [Go to the Guides](./core_concepts.md)

-   __API Reference__

    Need the technical details? Jump straight into the full API reference for all classes, methods, and parameters.

    [Go to the API Reference](./api_reference.md)
