"""Script to run a tracking demo with a pretrained policy.

This demo downloads a pretrained checkpoint and motion file from cloud storage
and launches an interactive viewer with a humanoid robot performing a cartwheel.
"""

from functools import partial

import tyro

from mjlab.scripts.gcs import ensure_default_checkpoint, ensure_default_motion
from mjlab.scripts.play import run_play

_TASK_NAME = "Mjlab-Tracking-Flat-Unitree-G1-Play"


def main() -> None:
  """Run demo with pretrained tracking policy."""
  print("🎮 Setting up MJLab demo with pretrained tracking policy...")

  try:
    checkpoint_path = ensure_default_checkpoint()
    motion_path = ensure_default_motion()
  except RuntimeError as e:
    print(f"❌ Failed to download demo assets: {e}")
    print("Please check your internet connection and try again.")
    return

  tyro.cli(
    partial(
      run_play,
      task=_TASK_NAME,
      checkpoint_file=checkpoint_path,
      motion_file=motion_path,
      render_all_envs=True,
    )
  )


if __name__ == "__main__":
  main()
