

"""Module Description

Copyright (c) 2009 H. Gene Shin <shin@jimmy.harvard.edu>

This code is free software; you can redistribute it and/or modify it
under the terms of the BSD License (see the file COPYING included with
the distribution).

@status:  experimental
@version: $Revision$
@author:  H. Gene Shin
@contact: shin@jimmy.harvard.edu

This module contains functions that produce R scripts corresponding to certain R functions. 
For example, R.plot(x,y) produces a R script of plot(x,y).

For the details on the parameters of the below functions, refer to R documents.
"""

# ------------------------------------
# import modules
# ------------------------------------
import itertools

# ------------------------------------
# Global variables for graphics
# ------------------------------------

# 'jet' color map - this obtained from MATLAB
JET128={'blue': [0.53125, 0.5625, 0.59375, 0.625, 0.65625, 0.6875, 0.71875, 0.75, 0.78125, 0.8125, 0.84375, 0.875, 0.90625, 0.9375,\
              0.96875, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,\
              1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.96875, 0.9375, 0.90625, 0.875, 0.84375, 0.8125, 0.78125, 0.75,
              0.71875, 0.6875, 0.65625, 0.625, 0.59375, 0.5625, 0.53125, 0.5, 0.46875, 0.4375, 0.40625, 0.375, 0.34375, 0.3125,\
              0.28125, 0.25, 0.21875, 0.1875, 0.15625, 0.125, 0.09375, 0.0625, 0.03125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,\
              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,\
              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],\
     'green': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.03125, 0.0625, 0.09375, 0.125,\
               0.15625, 0.1875, 0.21875, 0.25, 0.28125, 0.3125, 0.34375, 0.375, 0.40625, 0.4375, 0.46875, 0.5, 0.53125, 0.5625,\
               0.59375, 0.625, 0.65625, 0.6875, 0.71875, 0.75, 0.78125, 0.8125, 0.84375, 0.875, 0.90625, 0.9375, 0.96875, 1.0, 1.0,\
               1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,\
               1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.96875, 0.9375, 0.90625, 0.875, 0.84375, 0.8125, 0.78125, 0.75, 0.71875,\
               0.6875, 0.65625, 0.625, 0.59375, 0.5625, 0.53125, 0.5, 0.46875, 0.4375, 0.40625, 0.375, 0.34375, 0.3125, 0.28125,\
               0.25, 0.21875, 0.1875, 0.15625, 0.125, 0.09375, 0.0625, 0.03125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,\
               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],\
     'red': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,\
             0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,\
             0.03125, 0.0625, 0.09375, 0.125, 0.15625, 0.1875, 0.21875, 0.25, 0.28125, 0.3125, 0.34375, 0.375, 0.40625, 0.4375,\
             0.46875, 0.5, 0.53125, 0.5625, 0.59375, 0.625, 0.65625, 0.6875, 0.71875, 0.75, 0.78125, 0.8125, 0.84375, 0.875,\
             0.90625, 0.9375, 0.96875, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,\
             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.96875, 0.9375, 0.90625, 0.875,\
             0.84375, 0.8125, 0.78125, 0.75, 0.71875, 0.6875, 0.65625, 0.625, 0.59375, 0.5625, 0.53125, 0.5]}

# 'jet' color map - this obtained from MATLAB
JET256={'blue': [0.515625, 0.53125, 0.546875, 0.5625, 0.578125, 0.59375, 0.609375, 0.625, 0.640625, 0.65625, 0.671875, 0.6875, 0.703125, \
                 0.71875, 0.734375, 0.75, 0.765625, 0.78125, 0.796875, 0.8125, 0.828125, 0.84375, 0.859375, 0.875, 0.890625, 0.90625, \
                 0.921875, 0.9375, 0.953125, 0.96875, 0.984375, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                 1.0, 1.0, 1.0, 0.984375, 0.96875, 0.953125, 0.9375, 0.921875, 0.90625, 0.890625, 0.875, 0.859375, 0.84375, 0.828125, 0.8125, \
                 0.796875, 0.78125, 0.765625, 0.75, 0.734375, 0.71875, 0.703125, 0.6875, 0.671875, 0.65625, 0.640625, 0.625, 0.609375, 0.59375, \
                 0.578125, 0.5625, 0.546875, 0.53125, 0.515625, 0.5, 0.484375, 0.46875, 0.453125, 0.4375, 0.421875, 0.40625, 0.390625, 0.375, \
                 0.359375, 0.34375, 0.328125, 0.3125, 0.296875, 0.28125, 0.265625, 0.25, 0.234375, 0.21875, 0.203125, 0.1875, 0.171875, 0.15625, \
                 0.140625, 0.125, 0.109375, 0.09375, 0.078125, 0.0625, 0.046875, 0.03125, 0.015625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], \
        'green': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                  0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.015625, 0.03125, 0.046875, 0.0625, 0.078125, 0.09375, 0.109375, 0.125, 0.140625, 0.15625, \
                  0.171875, 0.1875, 0.203125, 0.21875, 0.234375, 0.25, 0.265625, 0.28125, 0.296875, 0.3125, 0.328125, 0.34375, 0.359375, 0.375, \
                  0.390625, 0.40625, 0.421875, 0.4375, 0.453125, 0.46875, 0.484375, 0.5, 0.515625, 0.53125, 0.546875, 0.5625, 0.578125, 0.59375, \
                  0.609375, 0.625, 0.640625, 0.65625, 0.671875, 0.6875, 0.703125, 0.71875, 0.734375, 0.75, 0.765625, 0.78125, 0.796875, 0.8125, \
                  0.828125, 0.84375, 0.859375, 0.875, 0.890625, 0.90625, 0.921875, 0.9375, 0.953125, 0.96875, 0.984375, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.984375, 0.96875, 0.953125, 0.9375, 0.921875, 0.90625, 0.890625, 0.875, \
                  0.859375, 0.84375, 0.828125, 0.8125, 0.796875, 0.78125, 0.765625, 0.75, 0.734375, 0.71875, 0.703125, 0.6875, 0.671875, 0.65625, \
                  0.640625, 0.625, 0.609375, 0.59375, 0.578125, 0.5625, 0.546875, 0.53125, 0.515625, 0.5, 0.484375, 0.46875, 0.453125, 0.4375, \
                  0.421875, 0.40625, 0.390625, 0.375, 0.359375, 0.34375, 0.328125, 0.3125, 0.296875, 0.28125, 0.265625, 0.25, 0.234375, 0.21875, \
                  0.203125, 0.1875, 0.171875, 0.15625, 0.140625, 0.125, 0.109375, 0.09375, 0.078125, 0.0625, 0.046875, 0.03125, 0.015625, 0.0, \
                  0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                  0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],\
        'red': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, \
                0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.015625, 0.03125, \
                0.046875, 0.0625, 0.078125, 0.09375, 0.109375, 0.125, 0.140625, 0.15625, 0.171875, 0.1875, 0.203125, 0.21875, 0.234375, \
                0.25, 0.265625, 0.28125, 0.296875, 0.3125, 0.328125, 0.34375, 0.359375, 0.375, 0.390625, 0.40625, 0.421875, 0.4375, 0.453125, \
                0.46875, 0.484375, 0.5, 0.515625, 0.53125, 0.546875, 0.5625, 0.578125, 0.59375, 0.609375, 0.625, 0.640625, 0.65625, 0.671875, \
                0.6875, 0.703125, 0.71875, 0.734375, 0.75, 0.765625, 0.78125, 0.796875, 0.8125, 0.828125, 0.84375, 0.859375, 0.875, 0.890625, \
                0.90625, 0.921875, 0.9375, 0.953125, 0.96875, 0.984375, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                1.0, 0.984375, 0.96875, 0.953125, 0.9375, 0.921875, 0.90625, 0.890625, 0.875, 0.859375, 0.84375, 0.828125, 0.8125, 0.796875, \
                0.78125, 0.765625, 0.75, 0.734375, 0.71875, 0.703125, 0.6875, 0.671875, 0.65625, 0.640625, 0.625, 0.609375, 0.59375, \
                0.578125, 0.5625, 0.546875, 0.53125, 0.515625, 0.5]}   

# cool 256 colors - this obtained from MATLAB
COOL256={'blue': [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, \
                  1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0], \
         'green': [1.0, 0.99607842999999996, 0.99215686000000003, 0.98823528999999999, 0.98431373, 0.98039215999999996, 0.97647059000000003, \
                   0.97254901999999999, 0.96862744999999995, 0.96470588000000002, 0.96078430999999997, 0.95686274999999998, 0.95294118000000005, \
                   0.94901961000000001, 0.94509803999999997, 0.94117647000000004, 0.9372549, 0.93333332999999996, 0.92941176000000003, \
                   0.92549020000000004, 0.92156863, 0.91764705999999996, 0.91372549000000003, 0.90980391999999999, 0.90588234999999995, \
                   0.90196078000000002, 0.89803922000000003, 0.89411764999999999, 0.89019607999999995, 0.88627451000000002, 0.88235293999999997, \
                   0.87843137000000004, 0.8745098, 0.87058824000000001, 0.86666666999999997, 0.86274510000000004, 0.85882353, 0.85490195999999996, \
                   0.85098039000000003, 0.84705881999999999, 0.84313724999999995, 0.83921568999999996, 0.83529412000000003, 0.83137254999999999, \
                   0.82745097999999995, 0.82352941000000002, 0.81960783999999998, 0.81568627000000005, 0.81176470999999994, 0.80784314000000002, \
                   0.80392156999999997, 0.80000000000000004, 0.79607843, 0.79215685999999996, 0.78823529000000003, 0.78431373000000004, 0.78039216, \
                   0.77647058999999996, 0.77254902000000003, 0.76862744999999999, 0.76470587999999995, 0.76078431000000002, 0.75686275000000003, \
                   0.75294117999999999, 0.74901960999999995, 0.74509804000000002, 0.74117646999999998, 0.73725490000000005, 0.73333333000000001, \
                   0.72941175999999996, 0.72549019999999997, 0.72156863000000004, 0.71764706, 0.71372548999999996, 0.70980392000000003, \
                   0.70588234999999999, 0.70196077999999995, 0.69803921999999996, 0.69411765000000003, 0.69019607999999999, 0.68627450999999995, \
                   0.68235294000000002, 0.67843136999999998, 0.67450980000000005, 0.67058823999999995, 0.66666667000000002, 0.66274509999999998, \
                   0.65882353000000005, 0.65490196000000001, 0.65098038999999996, 0.64705882000000003, 0.64313724999999999, 0.63921569, \
                   0.63529411999999996, 0.63137255000000003, 0.62745097999999999, 0.62352940999999995, 0.61960784000000002, 0.61568626999999998, \
                   0.61176470999999999, 0.60784313999999995, 0.60392157000000002, 0.59999999999999998, 0.59607843000000005, 0.59215686000000001, \
                   0.58823528999999997, 0.58431372999999998, 0.58039216000000005, 0.57647059, 0.57254901999999996, 0.56862745000000003, \
                   0.56470587999999999, 0.56078430999999995, 0.55686274999999996, 0.55294118000000003, 0.54901960999999999, 0.54509803999999995, \
                   0.54117647000000002, 0.53725489999999998, 0.53333333000000005, 0.52941176000000001, 0.52549020000000002, 0.52156862999999998, \
                   0.51764706000000005, 0.51372549000000001, 0.50980391999999997, 0.50588235000000004, 0.50196078, 0.49803922, 0.49411765000000002, \
                   0.49019607999999998, 0.48627450999999999, 0.48235294000000001, 0.47843137000000002, 0.47450979999999998, 0.47058823999999999, \
                   0.46666667000000001, 0.46274510000000002, 0.45882352999999998, 0.45490195999999999, 0.45098039000000001, 0.44705882000000002, \
                   0.44313724999999998, 0.43921568999999999, 0.43529412000000001, 0.43137255000000002, 0.42745097999999998, 0.42352941, \
                   0.41960784000000001, 0.41568627000000002, 0.41176470999999998, 0.40784313999999999, 0.40392157000000001, 0.40000000000000002, \
                   0.39607842999999998, 0.39215686, 0.38823529000000001, 0.38431373000000002, 0.38039215999999998, 0.37647058999999999, \
                   0.37254902000000001, 0.36862745000000002, 0.36470587999999998, 0.36078431, 0.35686275000000001, 0.35294118000000002, \
                   0.34901960999999998, 0.34509803999999999, 0.34117647000000001, 0.33725490000000002, 0.33333332999999998, 0.32941176, \
                   0.32549020000000001, 0.32156863000000002, 0.31764705999999998, 0.31372549, 0.30980392000000001, 0.30588235000000003, \
                   0.30196077999999998, 0.29803921999999999, 0.29411765000000001, 0.29019608000000002, 0.28627450999999998, 0.28235294, \
                   0.27843137000000001, 0.27450980000000003, 0.27058823999999998, 0.26666666999999999, 0.26274510000000001, 0.25882353000000002, \
                   0.25490195999999998, 0.25098039, 0.24705882000000001, 0.24313725, 0.23921569000000001, 0.23529412, 0.23137255000000001, \
                   0.22745098, 0.22352941000000001, 0.21960784, 0.21568627000000001, 0.21176470999999999, 0.20784314000000001, 0.20392157, \
                   0.20000000000000001, 0.19607843, 0.19215686000000001, 0.18823529, 0.18431373000000001, 0.18039216, 0.17647059000000001, \
                   0.17254902, 0.16862745000000001, 0.16470588, 0.16078431000000001, 0.15686275, 0.15294118000000001, 0.14901961, \
                   0.14509804000000001, 0.14117647, 0.13725490000000001, 0.13333333, 0.12941175999999999, 0.1254902, 0.12156863, 0.11764706, \
                   0.11372549, 0.10980392, 0.10588235, 0.10196078, 0.098039215999999998, 0.094117646999999999, 0.090196077999999999, \
                   0.086274509999999999, 0.082352940999999999, 0.078431372999999999, 0.074509803999999999, 0.070588234999999999, \
                   0.066666666999999999, 0.062745097999999999, 0.058823528999999999, 0.054901960999999999, 0.050980391999999999, \
                   0.047058823999999999, 0.043137254999999999, 0.039215686, 0.035294117999999999, 0.031372549, 0.02745098, 0.023529412, \
                   0.019607843, 0.015686275, 0.011764706, 0.0078431373000000006, 0.0039215685999999996, 0.0], \
         'red': [0.0, 0.0039215685999999996, 0.0078431373000000006, 0.011764706, 0.015686275, 0.019607843, 0.023529412, 0.02745098, 0.031372549, \
                 0.035294117999999999, 0.039215686, 0.043137254999999999, 0.047058823999999999, 0.050980391999999999, 0.054901960999999999, \
                 0.058823528999999999, 0.062745097999999999, 0.066666666999999999, 0.070588234999999999, 0.074509803999999999, 0.078431372999999999, \
                 0.082352940999999999, 0.086274509999999999, 0.090196077999999999, 0.094117646999999999, 0.098039215999999998, 0.10196078, 0.10588235, \
                 0.10980392, 0.11372549, 0.11764706, 0.12156863, 0.1254902, 0.12941175999999999, 0.13333333, 0.13725490000000001, 0.14117647, \
                 0.14509804000000001, 0.14901961, 0.15294118000000001, 0.15686275, 0.16078431000000001, 0.16470588, 0.16862745000000001, \
                 0.17254902, 0.17647059000000001, 0.18039216, 0.18431373000000001, 0.18823529, 0.19215686000000001, 0.19607843, 0.20000000000000001, \
                 0.20392157, 0.20784314000000001, 0.21176470999999999, 0.21568627000000001, 0.21960784, 0.22352941000000001, 0.22745098, \
                 0.23137255000000001, 0.23529412, 0.23921569000000001, 0.24313725, 0.24705882000000001, 0.25098039, 0.25490195999999998, \
                 0.25882353000000002, 0.26274510000000001, 0.26666666999999999, 0.27058823999999998, 0.27450980000000003, 0.27843137000000001, \
                 0.28235294, 0.28627450999999998, 0.29019608000000002, 0.29411765000000001, 0.29803921999999999, 0.30196077999999998, \
                 0.30588235000000003, 0.30980392000000001, 0.31372549, 0.31764705999999998, 0.32156863000000002, 0.32549020000000001, \
                 0.32941176, 0.33333332999999998, 0.33725490000000002, 0.34117647000000001, 0.34509803999999999, 0.34901960999999998, \
                 0.35294118000000002, 0.35686275000000001, 0.36078431, 0.36470587999999998, 0.36862745000000002, 0.37254902000000001, \
                 0.37647058999999999, 0.38039215999999998, 0.38431373000000002, 0.38823529000000001, 0.39215686, 0.39607842999999998, \
                 0.40000000000000002, 0.40392157000000001, 0.40784313999999999, 0.41176470999999998, 0.41568627000000002, \
                 0.41960784000000001, 0.42352941, 0.42745097999999998, 0.43137255000000002, 0.43529412000000001, 0.43921568999999999, \
                 0.44313724999999998, 0.44705882000000002, 0.45098039000000001, 0.45490195999999999, 0.45882352999999998, \
                 0.46274510000000002, 0.46666667000000001, 0.47058823999999999, 0.47450979999999998, 0.47843137000000002, \
                 0.48235294000000001, 0.48627450999999999, 0.49019607999999998, 0.49411765000000002, 0.49803922, 0.50196078, \
                 0.50588235000000004, 0.50980391999999997, 0.51372549000000001, 0.51764706000000005, 0.52156862999999998, 0.52549020000000002, \
                 0.52941176000000001, 0.53333333000000005, 0.53725489999999998, 0.54117647000000002, 0.54509803999999995, 0.54901960999999999, \
                 0.55294118000000003, 0.55686274999999996, 0.56078430999999995, 0.56470587999999999, 0.56862745000000003, 0.57254901999999996, \
                 0.57647059, 0.58039216000000005, 0.58431372999999998, 0.58823528999999997, 0.59215686000000001, 0.59607843000000005, \
                 0.59999999999999998, 0.60392157000000002, 0.60784313999999995, 0.61176470999999999, 0.61568626999999998, 0.61960784000000002, \
                 0.62352940999999995, 0.62745097999999999, 0.63137255000000003, 0.63529411999999996, 0.63921569, 0.64313724999999999, \
                 0.64705882000000003, 0.65098038999999996, 0.65490196000000001, 0.65882353000000005, 0.66274509999999998, 0.66666667000000002, \
                 0.67058823999999995, 0.67450980000000005, 0.67843136999999998, 0.68235294000000002, 0.68627450999999995, 0.69019607999999999, \
                 0.69411765000000003, 0.69803921999999996, 0.70196077999999995, 0.70588234999999999, 0.70980392000000003, 0.71372548999999996, \
                 0.71764706, 0.72156863000000004, 0.72549019999999997, 0.72941175999999996, 0.73333333000000001, 0.73725490000000005, \
                 0.74117646999999998, 0.74509804000000002, 0.74901960999999995, 0.75294117999999999, 0.75686275000000003, 0.76078431000000002, \
                 0.76470587999999995, 0.76862744999999999, 0.77254902000000003, 0.77647058999999996, 0.78039216, 0.78431373000000004, \
                 0.78823529000000003, 0.79215685999999996, 0.79607843, 0.80000000000000004, 0.80392156999999997, 0.80784314000000002, \
                 0.81176470999999994, 0.81568627000000005, 0.81960783999999998, 0.82352941000000002, 0.82745097999999995, 0.83137254999999999, \
                 0.83529412000000003, 0.83921568999999996, 0.84313724999999995, 0.84705881999999999, 0.85098039000000003, 0.85490195999999996, \
                 0.85882353, 0.86274510000000004, 0.86666666999999997, 0.87058824000000001, 0.8745098, 0.87843137000000004, 0.88235293999999997, \
                 0.88627451000000002, 0.89019607999999995, 0.89411764999999999, 0.89803922000000003, 0.90196078000000002, 0.90588234999999995, \
                 0.90980391999999999, 0.91372549000000003, 0.91764705999999996, 0.92156863, 0.92549020000000004, 0.92941176000000003, \
                 0.93333332999999996, 0.9372549, 0.94117647000000004, 0.94509803999999997, 0.94901961000000001, 0.95294118000000005, \
                 0.95686274999999998, 0.96078430999999997, 0.96470588000000002, 0.96862744999999995, 0.97254901999999999, 0.97647059000000003, \
                 0.98039215999999996, 0.98431373, 0.98823528999999999, 0.99215686000000003, 0.99607842999999996, 1.0]}

# green, black, and red 256
GBR256 = ["#00FF00","#00FD00","#00FB00","#00F900","#00F700","#00F500","#00F300","#00F100","#00EF00","#00ED00","#00EB00","#00E900","#00E700",\
          "#00E500","#00E300","#00E100","#00DF00","#00DD00","#00DB00","#00D900","#00D700","#00D500","#00D300","#00D100","#00CF00","#00CD00",\
          "#00CB00","#00C900","#00C700","#00C500","#00C300","#00C100","#00BF00","#00BD00","#00BB00","#00B900","#00B700","#00B500","#00B300",\
          "#00B100","#00AF00","#00AD00","#00AB00","#00A900","#00A700","#00A500","#00A300","#00A100","#009F00","#009D00","#009B00","#009900",\
          "#009700","#009500","#009300","#009100","#008F00","#008D00","#008B00","#008900","#008700","#008500","#008300","#008100","#007E00",\
          "#007C00","#007A00","#007800","#007600","#007400","#007200","#007000","#006E00","#006C00","#006A00","#006800","#006600","#006400",\
          "#006200","#006000","#005E00","#005C00","#005A00","#005800","#005600","#005400","#005200","#005000","#004E00","#004C00","#004A00",\
          "#004800","#004600","#004400","#004200","#004000","#003E00","#003C00","#003A00","#003800","#003600","#003400","#003200","#003000",\
          "#002E00","#002C00","#002A00","#002800","#002600","#002400","#002200","#002000","#001E00","#001C00","#001A00","#001800","#001600",\
          "#001400","#001200","#001000","#000E00","#000C00","#000A00","#000800","#000600","#000400","#000200","#000000","#000000","#020000",\
          "#040000","#060000","#080000","#0A0000","#0C0000","#0E0000","#100000","#120000","#140000","#160000","#180000","#1A0000","#1C0000",\
          "#1E0000","#200000","#220000","#240000","#260000","#280000","#2A0000","#2C0000","#2E0000","#300000","#320000","#340000","#360000",\
          "#380000","#3A0000","#3C0000","#3E0000","#400000","#420000","#440000","#460000","#480000","#4A0000","#4C0000","#4E0000","#500000",\
          "#520000","#540000","#560000","#580000","#5A0000","#5C0000","#5E0000","#600000","#620000","#640000","#660000","#680000","#6A0000",\
          "#6C0000","#6E0000","#700000","#720000","#740000","#760000","#780000","#7A0000","#7C0000","#7E0000","#810000","#830000","#850000",\
          "#870000","#890000","#8B0000","#8D0000","#8F0000","#910000","#930000","#950000","#970000","#990000","#9B0000","#9D0000","#9F0000",\
          "#A10000","#A30000","#A50000","#A70000","#A90000","#AB0000","#AD0000","#AF0000","#B10000","#B30000","#B50000","#B70000","#B90000",\
          "#BB0000","#BD0000","#BF0000","#C10000","#C30000","#C50000","#C70000","#C90000","#CB0000","#CD0000","#CF0000","#D10000","#D30000",\
          "#D50000","#D70000","#D90000","#DB0000","#DD0000","#DF0000","#E10000","#E30000","#E50000","#E70000","#E90000","#EB0000","#ED0000",\
          "#EF0000","#F10000","#F30000","#F50000","#F70000","#F90000","#FB0000","#FD0000","#FF0000"]

# black, and red 256
BR256 = ["#00FF00","#00FD00","#00FB00","#00F900","#00F700","#00F500","#00F300","#00F100","#00EF00","#00ED00","#00EB00","#00E900","#00E700",\
          "#00E500","#00E300","#00E100","#00DF00","#00DD00","#00DB00","#00D900","#00D700","#00D500","#00D300","#00D100","#00CF00","#00CD00",\
          "#00CB00","#00C900","#00C700","#00C500","#00C300","#00C100","#00BF00","#00BD00","#00BB00","#00B900","#00B700","#00B500","#00B300",\
          "#00B100","#00AF00","#00AD00","#00AB00","#00A900","#00A700","#00A500","#00A300","#00A100","#009F00","#009D00","#009B00","#009900",\
          "#009700","#009500","#009300","#009100","#008F00","#008D00","#008B00","#008900","#008700","#008500","#008300","#008100","#007E00",\
          "#007C00","#007A00","#007800","#007600","#007400","#007200","#007000","#006E00","#006C00","#006A00","#006800","#006600","#006400",\
          "#006200","#006000","#005E00","#005C00","#005A00","#005800","#005600","#005400","#005200","#005000","#004E00","#004C00","#004A00",\
          "#004800","#004600","#004400","#004200","#004000","#003E00","#003C00","#003A00","#003800","#003600","#003400","#003200","#003000",\
          "#002E00","#002C00","#002A00","#002800","#002600","#002400","#002200","#002000","#001E00","#001C00","#001A00","#001800","#001600",\
          "#001400","#001200","#001000","#000E00","#000C00","#000A00","#000800","#000600","#000400","#000200","#000000","#000000","#020000",\
          "#040000","#060000","#080000","#0A0000","#0C0000","#0E0000","#100000","#120000","#140000","#160000","#180000","#1A0000","#1C0000",\
          "#1E0000","#200000","#220000","#240000","#260000","#280000","#2A0000","#2C0000","#2E0000","#300000","#320000","#340000","#360000",\
          "#380000","#3A0000","#3C0000","#3E0000","#400000","#420000","#440000","#460000","#480000","#4A0000","#4C0000","#4E0000","#500000",\
          "#520000","#540000","#560000","#580000","#5A0000","#5C0000","#5E0000","#600000","#620000","#640000","#660000","#680000","#6A0000",\
          "#6C0000","#6E0000","#700000","#720000","#740000","#760000","#780000","#7A0000","#7C0000","#7E0000","#810000","#830000","#850000",\
          "#870000","#890000","#8B0000","#8D0000","#8F0000","#910000","#930000","#950000","#970000","#990000","#9B0000","#9D0000","#9F0000",\
          "#A10000","#A30000","#A50000","#A70000","#A90000","#AB0000","#AD0000","#AF0000","#B10000","#B30000","#B50000","#B70000","#B90000",\
          "#BB0000","#BD0000","#BF0000","#C10000","#C30000","#C50000","#C70000","#C90000","#CB0000","#CD0000","#CF0000","#D10000","#D30000",\
          "#D50000","#D70000","#D90000","#DB0000","#DD0000","#DF0000","#E10000","#E30000","#E50000","#E70000","#E90000","#EB0000","#ED0000",\
          "#EF0000","#F10000","#F30000","#F50000","#F70000","#F90000","#FB0000","#FD0000","#FF0000"]

# green, black 256
GB256 = ["#00FF00","#00FD00","#00FB00","#00F900","#00F700","#00F500","#00F300","#00F100","#00EF00","#00ED00","#00EB00","#00E900","#00E700",\
          "#00E500","#00E300","#00E100","#00DF00","#00DD00","#00DB00","#00D900","#00D700","#00D500","#00D300","#00D100","#00CF00","#00CD00",\
          "#00CB00","#00C900","#00C700","#00C500","#00C300","#00C100","#00BF00","#00BD00","#00BB00","#00B900","#00B700","#00B500","#00B300",\
          "#00B100","#00AF00","#00AD00","#00AB00","#00A900","#00A700","#00A500","#00A300","#00A100","#009F00","#009D00","#009B00","#009900",\
          "#009700","#009500","#009300","#009100","#008F00","#008D00","#008B00","#008900","#008700","#008500","#008300","#008100","#007E00",\
          "#007C00","#007A00","#007800","#007600","#007400","#007200","#007000","#006E00","#006C00","#006A00","#006800","#006600","#006400",\
          "#006200","#006000","#005E00","#005C00","#005A00","#005800","#005600","#005400","#005200","#005000","#004E00","#004C00","#004A00",\
          "#004800","#004600","#004400","#004200","#004000","#003E00","#003C00","#003A00","#003800","#003600","#003400","#003200","#003000",\
          "#002E00","#002C00","#002A00","#002800","#002600","#002400","#002200","#002000","#001E00","#001C00","#001A00","#001800","#001600",\
          "#001400","#001200","#001000","#000E00","#000C00","#000A00","#000800","#000600","#000400","#000200","#000000","#000000","#020000",\
          "#040000","#060000","#080000","#0A0000","#0C0000","#0E0000","#100000","#120000","#140000","#160000","#180000","#1A0000","#1C0000",\
          "#1E0000","#200000","#220000","#240000","#260000","#280000","#2A0000","#2C0000","#2E0000","#300000","#320000","#340000","#360000",\
          "#380000","#3A0000","#3C0000","#3E0000","#400000","#420000","#440000","#460000","#480000","#4A0000","#4C0000","#4E0000","#500000",\
          "#520000","#540000","#560000","#580000","#5A0000","#5C0000","#5E0000","#600000","#620000","#640000","#660000","#680000","#6A0000",\
          "#6C0000","#6E0000","#700000","#720000","#740000","#760000","#780000","#7A0000","#7C0000","#7E0000","#810000","#830000","#850000",\
          "#870000","#890000","#8B0000","#8D0000","#8F0000","#910000","#930000","#950000","#970000","#990000","#9B0000","#9D0000","#9F0000",\
          "#A10000","#A30000","#A50000","#A70000","#A90000","#AB0000","#AD0000","#AF0000","#B10000","#B30000","#B50000","#B70000","#B90000",\
          "#BB0000","#BD0000","#BF0000","#C10000","#C30000","#C50000","#C70000","#C90000","#CB0000","#CD0000","#CF0000","#D10000","#D30000",\
          "#D50000","#D70000","#D90000","#DB0000","#DD0000","#DF0000","#E10000","#E30000","#E50000","#E70000","#E90000","#EB0000","#ED0000",\
          "#EF0000","#F10000","#F30000","#F50000","#F70000","#F90000","#FB0000","#FD0000","#FF0000"]

# blue - black - yellow
BBY256 = ["#0000FF","#0000FD","#0000FB","#0000F9","#0000F7","#0000F5","#0000F3","#0000F1","#0000EF","#0000ED","#0000EB","#0000E9","#0000E7","#0000E5",\
          "#0000E3","#0000E1","#0000DF","#0000DD","#0000DB","#0000D9","#0000D7","#0000D5","#0000D3","#0000D1","#0000CF","#0000CD","#0000CB","#0000C9",\
          "#0000C7","#0000C5","#0000C3","#0000C1","#0000BF","#0000BD","#0000BB","#0000B9","#0000B7","#0000B5","#0000B3","#0000B1","#0000AF","#0000AD",\
          "#0000AB","#0000A9","#0000A7","#0000A5","#0000A3","#0000A1","#00009F","#00009D","#00009B","#000099","#000097","#000095","#000093","#000091",\
          "#00008F","#00008D","#00008B","#000089","#000087","#000085","#000083","#000081","#00007E","#00007C","#00007A","#000078","#000076","#000074",\
          "#000072","#000070","#00006E","#00006C","#00006A","#000068","#000066","#000064","#000062","#000060","#00005E","#00005C","#00005A","#000058",\
          "#000056","#000054","#000052","#000050","#00004E","#00004C","#00004A","#000048","#000046","#000044","#000042","#000040","#00003E","#00003C",\
          "#00003A","#000038","#000036","#000034","#000032","#000030","#00002E","#00002C","#00002A","#000028","#000026","#000024","#000022","#000020",\
          "#00001E","#00001C","#00001A","#000018","#000016","#000014","#000012","#000010","#00000E","#00000C","#00000A","#000008","#000006","#000004",\
          "#000002","#000000","#000000","#020200","#040400","#060600","#080800","#0A0A00","#0C0C00","#0E0E00","#101000","#121200","#141400","#161600",\
          "#181800","#1A1A00","#1C1C00","#1E1E00","#202000","#222200","#242400","#262600","#282800","#2A2A00","#2C2C00","#2E2E00","#303000","#323200",\
          "#343400","#363600","#383800","#3A3A00","#3C3C00","#3E3E00","#404000","#424200","#444400","#464600","#484800","#4A4A00","#4C4C00","#4E4E00",\
          "#505000","#525200","#545400","#565600","#585800","#5A5A00","#5C5C00","#5E5E00","#606000","#626200","#646400","#666600","#686800","#6A6A00",\
          "#6C6C00","#6E6E00","#707000","#727200","#747400","#767600","#787800","#7A7A00","#7C7C00","#7E7E00","#818100","#838300","#858500","#878700",\
          "#898900","#8B8B00","#8D8D00","#8F8F00","#919100","#939300","#959500","#979700","#999900","#9B9B00","#9D9D00","#9F9F00","#A1A100","#A3A300",\
          "#A5A500","#A7A700","#A9A900","#ABAB00","#ADAD00","#AFAF00","#B1B100","#B3B300","#B5B500","#B7B700","#B9B900","#BBBB00","#BDBD00","#BFBF00",\
          "#C1C100","#C3C300","#C5C500","#C7C700","#C9C900","#CBCB00","#CDCD00","#CFCF00","#D1D100","#D3D300","#D5D500","#D7D700","#D9D900","#DBDB00",\
          "#DDDD00","#DFDF00","#E1E100","#E3E300","#E5E500","#E7E700","#E9E900","#EBEB00","#EDED00","#EFEF00","#F1F100","#F3F300","#F5F500","#F7F700",\
          "#F9F900","#FBFB00","#FDFD00","#FFFF00"]

# jet 256 colors
JET256 = ['#000083', '#000087', '#00008B', '#00008F', '#000093', '#000097', '#00009B', '#00009F', '#0000A3', '#0000A7', '#0000AB', '#0000AF', \
          '#0000B3', '#0000B7', '#0000BB', '#0000BF', '#0000C3', '#0000C7', '#0000CB', '#0000CF', '#0000D3', '#0000D7', '#0000DB', '#0000DF', \
          '#0000E3', '#0000E7', '#0000EB', '#0000EF', '#0000F3', '#0000F7', '#0000FB', '#0000FF', '#0004FF', '#0008FF', '#000CFF', '#0010FF', \
          '#0014FF', '#0018FF', '#001CFF', '#0020FF', '#0024FF', '#0028FF', '#002CFF', '#0030FF', '#0034FF', '#0038FF', '#003CFF', '#0040FF', \
          '#0044FF', '#0048FF', '#004CFF', '#0050FF', '#0054FF', '#0058FF', '#005CFF', '#0060FF', '#0064FF', '#0068FF', '#006CFF', '#0070FF', \
          '#0074FF', '#0078FF', '#007CFF', '#0080FF', '#0083FF', '#0087FF', '#008BFF', '#008FFF', '#0093FF', '#0097FF', '#009BFF', '#009FFF', \
          '#00A3FF', '#00A7FF', '#00ABFF', '#00AFFF', '#00B3FF', '#00B7FF', '#00BBFF', '#00BFFF', '#00C3FF', '#00C7FF', '#00CBFF', '#00CFFF', \
          '#00D3FF', '#00D7FF', '#00DBFF', '#00DFFF', '#00E3FF', '#00E7FF', '#00EBFF', '#00EFFF', '#00F3FF', '#00F7FF', '#00FBFF', '#00FFFF', \
          '#04FFFB', '#08FFF7', '#0CFFF3', '#10FFEF', '#14FFEB', '#18FFE7', '#1CFFE3', '#20FFDF', '#24FFDB', '#28FFD7', '#2CFFD3', '#30FFCF', \
          '#34FFCB', '#38FFC7', '#3CFFC3', '#40FFBF', '#44FFBB', '#48FFB7', '#4CFFB3', '#50FFAF', '#54FFAB', '#58FFA7', '#5CFFA3', '#60FF9F', \
          '#64FF9B', '#68FF97', '#6CFF93', '#70FF8F', '#74FF8B', '#78FF87', '#7CFF83', '#80FF80', '#83FF7C', '#87FF78', '#8BFF74', '#8FFF70', \
          '#93FF6C', '#97FF68', '#9BFF64', '#9FFF60', '#A3FF5C', '#A7FF58', '#ABFF54', '#AFFF50', '#B3FF4C', '#B7FF48', '#BBFF44', '#BFFF40', \
          '#C3FF3C', '#C7FF38', '#CBFF34', '#CFFF30', '#D3FF2C', '#D7FF28', '#DBFF24', '#DFFF20', '#E3FF1C', '#E7FF18', '#EBFF14', '#EFFF10', \
          '#F3FF0C', '#F7FF08', '#FBFF04', '#FFFF00', '#FFFB00', '#FFF700', '#FFF300', '#FFEF00', '#FFEB00', '#FFE700', '#FFE300', '#FFDF00', \
          '#FFDB00', '#FFD700', '#FFD300', '#FFCF00', '#FFCB00', '#FFC700', '#FFC300', '#FFBF00', '#FFBB00', '#FFB700', '#FFB300', '#FFAF00', \
          '#FFAB00', '#FFA700', '#FFA300', '#FF9F00', '#FF9B00', '#FF9700', '#FF9300', '#FF8F00', '#FF8B00', '#FF8700', '#FF8300', '#FF8000', \
          '#FF7C00', '#FF7800', '#FF7400', '#FF7000', '#FF6C00', '#FF6800', '#FF6400', '#FF6000', '#FF5C00', '#FF5800', '#FF5400', '#FF5000', \
          '#FF4C00', '#FF4800', '#FF4400', '#FF4000', '#FF3C00', '#FF3800', '#FF3400', '#FF3000', '#FF2C00', '#FF2800', '#FF2400', '#FF2000', \
          '#FF1C00', '#FF1800', '#FF1400', '#FF1000', '#FF0C00', '#FF0800', '#FF0400', '#FF0000', '#FB0000', '#F70000', '#F30000', '#EF0000', \
          '#EB0000', '#E70000', '#E30000', '#DF0000', '#DB0000', '#D70000', '#D30000', '#CF0000', '#CB0000', '#C70000', '#C30000', '#BF0000', \
          '#BB0000', '#B70000', '#B30000', '#AF0000', '#AB0000', '#A70000', '#A30000', '#9F0000', '#9B0000', '#970000', '#930000', '#8F0000', \
          '#8B0000', '#870000', '#830000', '#800000']

# cool 256 colors
COOL256 = ['#00FFFF', '#01FEFF', '#02FDFF', '#03FCFF', '#04FBFF', '#05FAFF', '#06F9FF', '#07F8FF', '#08F7FF', '#09F6FF', '#0AF5FF', '#0BF4FF', \
           '#0CF3FF', '#0DF2FF', '#0EF1FF', '#0FF0FF', '#10EFFF', '#11EEFF', '#12EDFF', '#13ECFF', '#14EBFF', '#15EAFF', '#16E9FF', '#17E8FF', \
           '#18E7FF', '#19E6FF', '#1AE5FF', '#1BE4FF', '#1CE3FF', '#1DE2FF', '#1EE1FF', '#1FE0FF', '#20DFFF', '#21DEFF', '#22DDFF', '#23DCFF', \
           '#24DBFF', '#25DAFF', '#26D9FF', '#27D8FF', '#28D7FF', '#29D6FF', '#2AD5FF', '#2BD4FF', '#2CD3FF', '#2DD2FF', '#2ED1FF', '#2FD0FF', \
           '#30CFFF', '#31CEFF', '#32CDFF', '#33CCFF', '#34CBFF', '#35CAFF', '#36C9FF', '#37C8FF', '#38C7FF', '#39C6FF', '#3AC5FF', '#3BC4FF', \
           '#3CC3FF', '#3DC2FF', '#3EC1FF', '#3FC0FF', '#40BFFF', '#41BEFF', '#42BDFF', '#43BCFF', '#44BBFF', '#45BAFF', '#46B9FF', '#47B8FF', \
           '#48B7FF', '#49B6FF', '#4AB5FF', '#4BB4FF', '#4CB3FF', '#4DB2FF', '#4EB1FF', '#4FB0FF', '#50AFFF', '#51AEFF', '#52ADFF', '#53ACFF', \
           '#54ABFF', '#55AAFF', '#56A9FF', '#57A8FF', '#58A7FF', '#59A6FF', '#5AA5FF', '#5BA4FF', '#5CA3FF', '#5DA2FF', '#5EA1FF', '#5FA0FF', \
           '#609FFF', '#619EFF', '#629DFF', '#639CFF', '#649BFF', '#659AFF', '#6699FF', '#6798FF', '#6897FF', '#6996FF', '#6A95FF', '#6B94FF', \
           '#6C93FF', '#6D92FF', '#6E91FF', '#6F90FF', '#708FFF', '#718EFF', '#728DFF', '#738CFF', '#748BFF', '#758AFF', '#7689FF', '#7788FF', \
           '#7887FF', '#7986FF', '#7A85FF', '#7B84FF', '#7C83FF', '#7D82FF', '#7E81FF', '#7F80FF', '#807FFF', '#817EFF', '#827DFF', '#837CFF', \
           '#847BFF', '#857AFF', '#8679FF', '#8778FF', '#8877FF', '#8976FF', '#8A75FF', '#8B74FF', '#8C73FF', '#8D72FF', '#8E71FF', '#8F70FF', \
           '#906FFF', '#916EFF', '#926DFF', '#936CFF', '#946BFF', '#956AFF', '#9669FF', '#9768FF', '#9867FF', '#9966FF', '#9A65FF', '#9B64FF', \
           '#9C63FF', '#9D62FF', '#9E61FF', '#9F60FF', '#A05FFF', '#A15EFF', '#A25DFF', '#A35CFF', '#A45BFF', '#A55AFF', '#A659FF', '#A758FF', \
           '#A857FF', '#A956FF', '#AA55FF', '#AB54FF', '#AC53FF', '#AD52FF', '#AE51FF', '#AF50FF', '#B04FFF', '#B14EFF', '#B24DFF', '#B34CFF', \
           '#B44BFF', '#B54AFF', '#B649FF', '#B748FF', '#B847FF', '#B946FF', '#BA45FF', '#BB44FF', '#BC43FF', '#BD42FF', '#BE41FF', '#BF40FF', \
           '#C03FFF', '#C13EFF', '#C23DFF', '#C33CFF', '#C43BFF', '#C53AFF', '#C639FF', '#C738FF', '#C837FF', '#C936FF', '#CA35FF', '#CB34FF', \
           '#CC33FF', '#CD32FF', '#CE31FF', '#CF30FF', '#D02FFF', '#D12EFF', '#D22DFF', '#D32CFF', '#D42BFF', '#D52AFF', '#D629FF', '#D728FF', \
           '#D827FF', '#D926FF', '#DA25FF', '#DB24FF', '#DC23FF', '#DD22FF', '#DE21FF', '#DF20FF', '#E01FFF', '#E11EFF', '#E21DFF', '#E31CFF', \
           '#E41BFF', '#E51AFF', '#E619FF', '#E718FF', '#E817FF', '#E916FF', '#EA15FF', '#EB14FF', '#EC13FF', '#ED12FF', '#EE11FF', '#EF10FF', \
           '#F00FFF', '#F10EFF', '#F20DFF', '#F30CFF', '#F40BFF', '#F50AFF', '#F609FF', '#F708FF', '#F807FF', '#F906FF', '#FA05FF', '#FB04FF', \
           '#FC03FF', '#FD02FF', '#FE01FF', '#FF00FF']

# key colors for R's colorRampPalette function
GBR = ["green", "black", "red"]
BR = ["black", "red"]
GWR = ["green", "white", "red"]
BBY = ["blue", "black", "yellow"]
BY = ["black", "yellow"]
BBY = ["blue", "white", "yellow"]
JET = ["#00007F", "blue", "#007FFF", "cyan", "#7FFF7F", "yellow", "#FF7F00", "red", "#7F0000"]

# ------------------------------------
# funcitons
# ------------------------------------
def quantize(y, ylim=[], n_levels=128):
    """Quantize a list of continuous values according to the given number of levels
    
    Parameters:
    1. y: a list of continuous values to quantize
    2. ylim: the lower and upper limit. if [], the min and max of y is used
    3. n_levels: quantization level.
    
    Return
    qy: a list of integers. If n_levels is 128, integers in range of 0 to 127 will be returned. 
    
    """

    if not ylim: ylim = [min(y), max(y)]
    
    # saturate y
    qy = [max(i, ylim[0]) for i in y]
    qy = [min(i, ylim[1]) for i in qy]
    try:
        qy = [int(round((i - ylim[0])/(ylim[1]-ylim[0]) * (n_levels-1))) for i in qy]
    except ZeroDivsionError:
        qy = [0]*len(y)
    
    return qy

def convert2hex(x):
    """Convert the given R G B floating numbers to string hexa-decimal color code (256, FF)
    
    See above
    
    Parameters:
    1. x: a dictionary with 'red', 'green', and 'blue'.
    """
    
    red = ["%02X" %int(round(c*255)) for c in x['red']]
    green = ["%02X" %int(round(c*255)) for c in x['green']]
    blue = ["%02X" %int(round(c*255)) for c in x['blue']]
    
    return ["#"+"".join([r,g,b]) for r,g,b in zip(red,green,blue)]
    
    
