# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 17)
set(QT_UPDATE_VERSION OFF) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

# qt5-mqtt archive is not included in 5.15.17 release, updated separately
# list(APPEND QT_PORT_LIST mqtt)

set(QT_HASH_qt5-3d 94a88bf418f572a07b1ad25d6ca090525e7fe004c9f2d6ca7495e509fd150822bf5d49b66bed3660e492213bf54aff4e8772eeea0f42c24ef4f8c17f2655e2bc)
set(QT_HASH_qt5-activeqt 9089830042c01c990d85b842eafad8cb0c13606b90d310cf5f9e1e030e237c7ad362393ead31d7b6c507fd4623f08f17cb54abb1a21e24a0e42685ffcb3eab45)
set(QT_HASH_qt5-androidextras 9c950a43b8a13a702ee68a3adaa7d5f5666773762b9d8eb45d4202ad5ba016dcd6513d2feaffad0e284b5db4ca9f4e406e2a5408a304fb62bf2fc11952ed2fb9)
set(QT_HASH_qt5-base bd99bc25aee1c10d4161867654f3992c4e811b33337523bb702e3d2f63fb9a0d9118c43701ae791999c71761b86cdee1b6e5a1c520e47b52acbfe2156ce12621)
set(QT_HASH_qt5-charts 2b83853dba30c0fe23967a9eaae4a3bfe3f06608f994dd6f3cbac4cc2ac41856382105a539ee6596710a9cc51f88919229d31a3f90b4dde74a44e7c94e404845)
set(QT_HASH_qt5-connectivity 47617b29f963e05a6e65d9f5a685f6d20bdbd726c631c056c4a0e6037134b08bb956d9f705bee20ec73e0ec87117437acc2d52fe16e0f42ad312c887cc92c97b)
set(QT_HASH_qt5-datavis3d 4be0b0d17242227a9050839fffa84e3aa62e4d87e08aef51ac4ce98c9a8dd11ee2505e950f9ef244958db813b096cdcd2e1d2692a6066eba563c68a7a88f3a9e)
set(QT_HASH_qt5-declarative 7dbe9edfb43ab0b65bcf22c8b3226de851a210c8004b0c82dd346da5aa1ca4b8df0ca56ac78273d9d472252d8b756b62cc8e1d6432b048af947d51f4e9fef701)
set(QT_HASH_qt5-doc cfd9912ceb70f15fc92eaa79fb89f9274ea9ecacd0e707ffabe7cd21f32a9301151aa10e3724a7a9970ea9238c72fe0f664dee55b9911b38e3c96e4fa4d3a5d3)
set(QT_HASH_qt5-gamepad 321b00ccded43fd513c971bf5bafc5d6533db1d208047d52a2d208fc659cf783262ace1118f9393c5ffbb955c32cd32598296555f3d70079bb4837ef1d46c0ab)
set(QT_HASH_qt5-graphicaleffects 0745a3c928af94978f8d3d6748f6a09ad9b8086113371ef7c2729c0a6ab403a3dbdd34b0a4c53d8665e1bf6ddd47f8fbe4d346eab34c41515b9beff707b844a9)
set(QT_HASH_qt5-imageformats f73224594b3c1eb5b0da93143e21b13fa899d14bf93037022ded61c8e3594d5cce452b9090c9c522e5167baa22e8df45deb7b74f73af3451738efd7460d7a9e8)
set(QT_HASH_qt5-location 8ba1f386ce45201dbd3616a328ab256553c93da3bbb99fbe20b7b93419860f3a5612261258895e58b2621b8e05c8a841f3e9cb436384091e02e6a14b72a2be31)
set(QT_HASH_qt5-macextras 2ce07bf16e697e8e55a8237c84ae9e638f9d6305669e71408cc1985e2d225516c20c7985676e96b0c3e846848a70615fa4e4d626d57b3f280d12917106e45ea0)
set(QT_HASH_qt5-multimedia 75cfe80d2a4555769557742a0609be96b7c064aa8f2e28efb4dcf88a121dcd95080a1077f300dd20777519db2b75247f7021d4f5b7cd5a98a78919b35509fc49)
set(QT_HASH_qt5-networkauth 3f1442c91b36d461646a49bdc27c61253e4ad6a909a19f452e101cd3e9428a3cced4408216a5f80d6662101ba9f9f0d5a0c721adc9bd1e203f66bebc9e03ea64)
set(QT_HASH_qt5-purchasing 483ebd1d025da3fa431ecf74204262a27929fe2c03e56ba790b2555b817658663ac9cba2cfd76674d7959ade2da4f1d86f2f7d6492b5cd1d26e56e7197893aba)
set(QT_HASH_qt5-quick3d 34c3f60eb1c86bab19af85c99b084d7a9825f19c5a9b2ba55da967739f3b1887ff3c811fbd546e7281f33ce11669ac61ec660e4da9218744c5215385b0062683)
set(QT_HASH_qt5-quickcontrols b4c736db1f31d8f660f87283e477430a02eb4141cfb6ce9e9523a6df8a852d6d26734c6f68e2b06c654fa9da671ad9ac5527c305022e7cd59adb3354f2c5b89b)
set(QT_HASH_qt5-quickcontrols2 c5c0277e26ef96e7012e7e2eac6027ce0f1b18fa6149f7f431a7c6911c70959bf94f5ee45e4f25065835c7e0ee5fc3e6436e4b0bfd0099505215173c920a80db)
set(QT_HASH_qt5-quicktimeline a5158e8a21544d2f091193cf95e7f3bed1b66910e94b2268b6a1cb032f6f82a3705a8f938afcb228e1afe84e918f6d5707060416f3a598fa45c0810c21af59d2)
set(QT_HASH_qt5-remoteobjects e7af570d1f7d292929d2a1c328047d8293e722081f3d0beb6046cc44081e4395400a2db1238b6fd06a3de1f2f0b0725854088564f76e4870a71a1e4403ab805c)
set(QT_HASH_qt5-script 8acfb38df7a1d925210179423347f478780ed651b2da63e9547c1d48984b9ca759cd258da8d813307f9843d746ede4942850dcf5c26b61fcaf49e8b67dd3b427)
set(QT_HASH_qt5-scxml 1f2b393ab5bf9e1466a2d2b7f192656f3cc26dc2a94c4b4599734ac90a80186bcb9bdc0a57b929b2d4f07ef14b362401278be06657f41d859e1eaf7baef871b0)
set(QT_HASH_qt5-sensors 9404c642e654333630a203523a6cd96050fe891c55ecc29ae8828d586889025bba881a5267425e242cac1cfbaafa0a0e4cdc1a2108ebc287522c09820f97ad71)
set(QT_HASH_qt5-serialbus 91740db5cf9c018802575eec9774847e1118164f7f14a680c8dd3858383a2d7d9b1d9f0ea0ceb66ff2a05d2cd53b75d4a3fa99f88e10b3ffe7441a6fa9c70723)
set(QT_HASH_qt5-serialport cd31c7f15dd0f43edc38a287b8630ce4e45215bf572191765ea886182b539a1f99056dd1d17f596643df944e4745c72b273f2010a6b52370c367ff5e8519823d)
set(QT_HASH_qt5-speech 584fa104ee41b93cb7344ccdd3d0dc6cbfac6a7db623888b062479715f90205ea0aa4eea1c529eca80f7ebac955ba7e1b530eff49f30696fe180cb353ac12a60)
set(QT_HASH_qt5-svg 8994b995ecceffd386b10f0776dca81c776232af0742017f40df35149eac5160d7c62e92f2fea28082d9fe5ed91754af37eb3d49d8602750d5d0c349931a8e70)
set(QT_HASH_qt5-tools 053ff805a95516753dca0d2bfa392469c7ea763b7a99755c6e7a3c6d59afd4bc704ef9a3edfc81bd7ea8c0c37cbd11447201f075a2353774ae177cbba88ea679)
set(QT_HASH_qt5-translations b13dabbebf380ff57e7c9cf9cfe3edfa38c888b4dda7359b5326606ca76fbb86cc742420eb30c507c322b9c9e7f05f9d92f1a792e9d2530886493c7dae2df087)
set(QT_HASH_qt5-virtualkeyboard 584c63f5c79122452ce9e424187ec76daa8263f16da14c08de6026e81c8cfe93cece62101fe1a57a07f4905bc743340a295f7669bd9f739c7c156935aa585ff8)
set(QT_HASH_qt5-wayland b14c7e0b7a58ae258bd440b68ee7322bfa918d95bf8fac4509e7e2636c21e4576a022a6707383eda37ace1943dccb0eacd9eccacd04806494d2f44a0c59b0dec)
set(QT_HASH_qt5-webchannel 6d616f4143ee34eeab361eba86d2bcdd1a502b6290813ad0053163cd4ee1d1e7f2a0903b82d8632050bdab710d28c7b06d6a3bcf30ce1db398dcb78ebe014389)
set(QT_HASH_qt5-webengine f3f8a6e9b43e9a58a0b44777fd3333a621365f7cfe323207dfafdefe41f572a58b03ae9c00ab57cbd554d9d71c09d071b93841557099205d4b6dc474921bbfdf)
set(QT_HASH_qt5-webglplugin 8642312b0805fec4ab860fb0889887ac4f4a8e87016253249f6de1c2064acc7622c7ec5230816b732713499c8cad59f5dee0485ce3efd750d349ab2ae0da0337)
set(QT_HASH_qt5-websockets 59afb4a8992b3fd1ca50f26a5ae13b0ffd79ac321475963cfdc7e64ef7a1a070b8eee1052d1cff26fa0c3bda1d8bbb2849e8e84b4c15f1b4ba936cb54a6f4014)
set(QT_HASH_qt5-webview d1bb3be0df0a9c3a8bdbd26af3210925f0c8f0985ba702736e79d8a9e0bb49369ec2450376b56369d199763fdcfe7b1f009c985c600d77370029682448304387)
set(QT_HASH_qt5-winextras bfcdeedb17354b43108fc938ad42526bda2c216030b00a07c9d52412d50c831db772691239faf849971c5e28704289221fd8c53aba85e7fef7240195b5d6333b)
set(QT_HASH_qt5-x11extras f66ea15f8eddd75aa396f3b4aba2f9acdb69fe1330c45b973c9e445a089a923ba6290edc5d9608e72ddd0dde9a55f7205ee539abe7846222a9905566133a2700)
set(QT_HASH_qt5-xmlpatterns 45c01b5b0d0345f0dffd0855eb05e8824462dbef729b8c26aa0561d1366395ae3586e03a8f1ce16965bfe57c510b7332c41d7706fc4d5a9683cde58ca77b86cb)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
