import unicodedata
import os
import json
from typing import Any, Callable, TypeVar

CALLABLE_T = TypeVar("CALLABLE_T", bound=Callable[..., Any])
CALLBACK_TYPE = Callable[[], None]


def callback(func: CALLABLE_T) -> CALLABLE_T:
    """Annotation to mark method as safe to call from within the event loop."""
    setattr(func, "_boneio_callback", True)
    return func


def is_callback(func: Callable[..., Any]) -> bool:
    """Check if function is safe to be called in the event loop."""
    return getattr(func, "_boneio_callback", False) is True


def strip_accents(s):

    return "".join(
        c
        for c in unicodedata.normalize("NFD", s)
        if unicodedata.category(c) != "Mn" and c != " "
    )


def open_json(path: str, model: str) -> dict:
    """Open json file."""
    file = f"{os.path.join(path)}/{model}.json"
    with open(file, "r") as db_file:
        datastore = json.load(db_file)
        return datastore
