import click
from adxp_cli.agent.cli import agent
from adxp_cli.auth.cli import auth
from adxp_cli.model.cli import model
from adxp_cli.finetuning.cli import finetuning
from adxp_cli.apikey.cli import apikey
from adxp_cli.prompts.cli import prompts
from adxp_cli.authorization.cli import authorization
from adxp_cli.dataset.cli import cli as dataset
from adxp_cli.knowledge.cli import knowledge
from adxp_cli.lineage.cli import lineage_group as lineage


@click.group()
def cli():
    """Command-line interface for AIP server management."""
    pass


cli.add_command(auth)
cli.add_command(agent)
cli.add_command(model)
cli.add_command(finetuning)
cli.add_command(apikey)
cli.add_command(prompts)   
cli.add_command(authorization, "authorization")
cli.add_command(authorization, "authz")
cli.add_command(dataset, "dataset")
cli.add_command(knowledge)
cli.add_command(lineage)

if __name__ == "__main__":
    cli()
