from adxp_cli.auth.service import get_credential
from adxp_sdk.auth.credentials import ApiKeyCredentials
from adxp_sdk.models.hub import ModelHub
import click

# ModelHub 인스턴스 생성 함수

def get_model_hub():
    headers, config = get_credential()
    credentials = ApiKeyCredentials(
        api_key=config.token,
        base_url=config.base_url
    )
    return ModelHub(credentials)

def create_custom_runtime(runtime_data: dict):
    try:
        hub = get_model_hub()
        result = hub.create_custom_runtime(runtime_data)
        click.secho("✅ Custom runtime created successfully", fg="green")
        return result
    except Exception as e:
        error_msg = str(e)
        if "401" in error_msg or "Unauthorized" in error_msg:
            raise click.ClickException(
                "🔐 401 Unauthorized : Please login again. \n Run Either One of the Following Commands \n 1. adxp-cli auth login \n 2. adxp-cli auth refresh"
            )
        raise click.ClickException(f"❌ Failed to create custom runtime: {e}")

def get_custom_runtime_by_model(model_id: str):
    try:
        hub = get_model_hub()
        result = hub.get_custom_runtime_by_model(model_id)
        click.secho("✅ Custom runtime retrieved", fg="green")
        return result
    except Exception as e:
        error_msg = str(e)
        if "401" in error_msg or "Unauthorized" in error_msg:
            raise click.ClickException(
                "🔐 401 Unauthorized : Please login again. \n Run Either One of the Following Commands \n 1. adxp-cli auth login \n 2. adxp-cli auth refresh"
            )
        raise click.ClickException(f"❌ Failed to get custom runtime: {e}")

def delete_custom_runtime_by_model(model_id: str):
    try:
        hub = get_model_hub()
        result = hub.delete_custom_runtime_by_model(model_id)
        click.secho("✅ Custom runtime deleted successfully", fg="green")
        return result
    except Exception as e:
        error_msg = str(e)
        if "401" in error_msg or "Unauthorized" in error_msg:
            raise click.ClickException(
                "🔐 401 Unauthorized : Please login again. \n Run Either One of the Following Commands \n 1. adxp-cli auth login \n 2. adxp-cli auth refresh"
            )
        raise click.ClickException(f"❌ Failed to delete custom runtime: {e}")