"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddCfnInitProxy = exports.ProxyType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_autoscaling_1 = require("aws-cdk-lib/aws-autoscaling");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
/**
 * Whether an http-proxy or https-proxy
 */
var ProxyType;
(function (ProxyType) {
    /**
     * --http-proxy
     */
    ProxyType[ProxyType["HTTP"] = 0] = "HTTP";
    /**
     * --https-proxy
     */
    ProxyType[ProxyType["HTTPS"] = 1] = "HTTPS";
})(ProxyType = exports.ProxyType || (exports.ProxyType = {}));
/**
 * Add proxy configuration to Cloudformation helper functions
 *
 * @extends IAspect
 */
class AddCfnInitProxy {
    constructor(props) {
        this._proxyHost = props.proxyHost;
        this._proxyPort = props.proxyPort;
        this._proxyType = props.proxyType || ProxyType.HTTP;
        this._proxyCredentials = props.proxyCredentials || undefined;
        this._proxyValue = this.determineProxyValue();
        this._initResourceTypes = [
            'AWS::AutoScaling::LaunchConfiguration',
            'AWS::EC2::Instance',
        ];
    }
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource &&
            this._initResourceTypes.includes(node.cfnResourceType)) {
            let userData;
            if (node.cfnResourceType == aws_ec2_1.CfnInstance.CFN_RESOURCE_TYPE_NAME) {
                const instanceNode = node;
                userData = aws_cdk_lib_1.Stack.of(node).resolve(instanceNode.userData);
            }
            else if (node.cfnResourceType == aws_autoscaling_1.CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME) {
                const launchConfigNode = node;
                userData = aws_cdk_lib_1.Stack.of(node).resolve(launchConfigNode.userData);
            }
            const commandList = userData['Fn::Base64']['Fn::Join'][1];
            const resourceIndexes = this.indexOfList('--resource', commandList);
            for (let i = 0, j = 0; i < resourceIndexes.length; i++, j += this._proxyValue.length) {
                const lineIdx = resourceIndexes[i] + j;
                commandList.splice(lineIdx, 0, ...this._proxyValue);
            }
            node.addPropertyOverride('UserData.Fn::Base64.Fn::Join', [
                '',
                commandList,
            ]);
        }
    }
    determineProxyValue() {
        const result = [];
        if (this._proxyType == ProxyType.HTTP) {
            result.push(' --http-proxy http://');
        }
        else {
            result.push(' --https-proxy https://');
        }
        if (this._proxyCredentials) {
            result.push(`${this._proxyCredentials
                .secretValueFromJson('user')
                .unsafeUnwrap()}:${this._proxyCredentials
                .secretValueFromJson('password')
                .unsafeUnwrap()}@`);
        }
        result.push(`${this._proxyHost}:${this._proxyPort}`);
        return result;
    }
    indexOfList(needle, haystack) {
        const result = [];
        for (let idx = 0; idx < haystack.length; idx++) {
            const command = haystack[idx];
            if (command instanceof Object)
                continue;
            if (command.indexOf(needle) >= 0) {
                result.push(idx);
            }
        }
        return result;
    }
}
exports.AddCfnInitProxy = AddCfnInitProxy;
_a = JSII_RTTI_SYMBOL_1;
AddCfnInitProxy[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.AddCfnInitProxy", version: "0.0.250" };
//# sourceMappingURL=data:application/json;base64,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