import { IAspect } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
/**
 * Add one or more environment variables to _all_ lambda functions within a scope
 *
 * @extends IAspect
 */
export declare class AddLambdaEnvironmentVariables implements IAspect {
    /**
     * Key value pairs of environment variables to add to all lambda functions within the scope
     */
    private _environmentKeyValues;
    /**
     *
     * @param props {[key: string]: string} props - Key Value pair(s) for environment variables to add to all lambda functions
     */
    constructor(props: {
        [key: string]: string;
    });
    visit(node: IConstruct): void;
}
