"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddPermissionBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const utils_1 = require("../utils/utils");
/**
 * A patch for Adding Permissions Boundaries to all IAM roles
 *
 * Additional options for adding prefixes to IAM role, policy and instance profile names
 *
 * Can account for non commercial partitions (e.g. aws-gov, aws-cn)
 */
class AddPermissionBoundary {
    constructor(props) {
        this._permissionsBoundaryPolicyName = props.permissionsBoundaryPolicyName;
        this._rolePrefix = props.rolePrefix || '';
        this._policyPrefix = props.policyPrefix || '';
        this._instanceProfilePrefix = props.instanceProfilePrefix || '';
    }
    checkAndOverride(node, prefix, length, cfnProp, cdkProp) {
        if (!cdkProp?.startsWith(prefix)) {
            if (cdkProp != undefined) {
                const policySuffix = !aws_cdk_lib_1.Token.isUnresolved(cdkProp)
                    ? cdkProp
                    : utils_1.getResourceId(node.node.path);
                node.addPropertyOverride(cfnProp, `${prefix}${policySuffix.replace(/\s/g, '')}`.substring(0, length - 1));
            }
        }
    }
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource) {
            const cfnResourceNode = node;
            if (cfnResourceNode.cfnResourceType == 'AWS::IAM::Role') {
                const permissionsBoundaryPolicyArn = aws_cdk_lib_1.Stack.of(node).formatArn({
                    service: 'iam',
                    resource: 'policy',
                    region: '',
                    resourceName: this._permissionsBoundaryPolicyName,
                });
                node.addPropertyOverride('PermissionsBoundary', permissionsBoundaryPolicyArn);
                this.checkAndOverride(node, this._rolePrefix, 64, 'RoleName', cfnResourceNode.logicalId);
            }
        }
        if (node instanceof aws_iam_1.CfnRole) {
            const permissionsBoundaryPolicyArn = aws_cdk_lib_1.Stack.of(node).formatArn({
                service: 'iam',
                resource: 'policy',
                region: '',
                resourceName: this._permissionsBoundaryPolicyName,
            });
            node.addPropertyOverride('PermissionsBoundary', permissionsBoundaryPolicyArn);
            this.checkAndOverride(node, this._rolePrefix, 64, 'RoleName', node.roleName);
        }
        else if (node instanceof aws_iam_1.CfnPolicy) {
            this.checkAndOverride(node, this._policyPrefix, 128, 'PolicyName', node.policyName);
        }
        else if (node instanceof aws_iam_1.CfnManagedPolicy) {
            this.checkAndOverride(node, this._policyPrefix, 128, 'ManagedPolicyName', node.managedPolicyName);
        }
        else if (node instanceof aws_iam_1.CfnInstanceProfile) {
            this.checkAndOverride(node, this._instanceProfilePrefix, 128, 'InstanceProfileName', node.instanceProfileName);
        }
    }
}
exports.AddPermissionBoundary = AddPermissionBoundary;
_a = JSII_RTTI_SYMBOL_1;
AddPermissionBoundary[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.AddPermissionBoundary", version: "0.0.250" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWRkUGVybWlzc2lvbnNCb3VuZGFyeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9wYXRjaGVzL2FkZFBlcm1pc3Npb25zQm91bmRhcnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTs7O0VBR0U7QUFDRiw2Q0FBaUU7QUFDakUsaURBSzZCO0FBRTdCLDBDQUErQztBQTJCL0M7Ozs7OztHQU1HO0FBQ0gsTUFBYSxxQkFBcUI7SUFNaEMsWUFBWSxLQUFpQztRQUMzQyxJQUFJLENBQUMsOEJBQThCLEdBQUcsS0FBSyxDQUFDLDZCQUE2QixDQUFDO1FBQzFFLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUM7UUFDMUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxJQUFJLEVBQUUsQ0FBQztRQUM5QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixJQUFJLEVBQUUsQ0FBQztJQUNsRSxDQUFDO0lBRU0sZ0JBQWdCLENBQ3JCLElBQWlCLEVBQ2pCLE1BQWMsRUFDZCxNQUFjLEVBQ2QsT0FBZSxFQUNmLE9BQWdCO1FBRWhCLElBQUksQ0FBQyxPQUFPLEVBQUUsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQ2hDLElBQUksT0FBTyxJQUFJLFNBQVMsRUFBRTtnQkFDeEIsTUFBTSxZQUFZLEdBQUcsQ0FBQyxtQkFBSyxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUM7b0JBQy9DLENBQUMsQ0FBRSxPQUFrQjtvQkFDckIsQ0FBQyxDQUFDLHFCQUFhLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFFbEMsSUFBSSxDQUFDLG1CQUFtQixDQUN0QixPQUFPLEVBQ1AsR0FBRyxNQUFNLEdBQUcsWUFBWSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxFQUFFLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FDdkUsQ0FBQzthQUNIO1NBQ0Y7SUFDSCxDQUFDO0lBRU0sS0FBSyxDQUFDLElBQWdCO1FBQzNCLElBQUksSUFBSSxZQUFZLHlCQUFXLEVBQUU7WUFDL0IsTUFBTSxlQUFlLEdBQWdCLElBQUksQ0FBQztZQUMxQyxJQUFJLGVBQWUsQ0FBQyxlQUFlLElBQUksZ0JBQWdCLEVBQUU7Z0JBQ3ZELE1BQU0sNEJBQTRCLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUM1RCxPQUFPLEVBQUUsS0FBSztvQkFDZCxRQUFRLEVBQUUsUUFBUTtvQkFDbEIsTUFBTSxFQUFFLEVBQUU7b0JBQ1YsWUFBWSxFQUFFLElBQUksQ0FBQyw4QkFBOEI7aUJBQ2xELENBQUMsQ0FBQztnQkFDSCxJQUFJLENBQUMsbUJBQW1CLENBQ3RCLHFCQUFxQixFQUNyQiw0QkFBNEIsQ0FDN0IsQ0FBQztnQkFDRixJQUFJLENBQUMsZ0JBQWdCLENBQ25CLElBQUksRUFDSixJQUFJLENBQUMsV0FBVyxFQUNoQixFQUFFLEVBQ0YsVUFBVSxFQUNWLGVBQWUsQ0FBQyxTQUFTLENBQzFCLENBQUM7YUFDSDtTQUNGO1FBQ0QsSUFBSSxJQUFJLFlBQVksaUJBQU8sRUFBRTtZQUMzQixNQUFNLDRCQUE0QixHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQztnQkFDNUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsUUFBUSxFQUFFLFFBQVE7Z0JBQ2xCLE1BQU0sRUFBRSxFQUFFO2dCQUNWLFlBQVksRUFBRSxJQUFJLENBQUMsOEJBQThCO2FBQ2xELENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxtQkFBbUIsQ0FDdEIscUJBQXFCLEVBQ3JCLDRCQUE0QixDQUM3QixDQUFDO1lBQ0YsSUFBSSxDQUFDLGdCQUFnQixDQUNuQixJQUFJLEVBQ0osSUFBSSxDQUFDLFdBQVcsRUFDaEIsRUFBRSxFQUNGLFVBQVUsRUFDVixJQUFJLENBQUMsUUFBUSxDQUNkLENBQUM7U0FDSDthQUFNLElBQUksSUFBSSxZQUFZLG1CQUFTLEVBQUU7WUFDcEMsSUFBSSxDQUFDLGdCQUFnQixDQUNuQixJQUFJLEVBQ0osSUFBSSxDQUFDLGFBQWEsRUFDbEIsR0FBRyxFQUNILFlBQVksRUFDWixJQUFJLENBQUMsVUFBVSxDQUNoQixDQUFDO1NBQ0g7YUFBTSxJQUFJLElBQUksWUFBWSwwQkFBZ0IsRUFBRTtZQUMzQyxJQUFJLENBQUMsZ0JBQWdCLENBQ25CLElBQUksRUFDSixJQUFJLENBQUMsYUFBYSxFQUNsQixHQUFHLEVBQ0gsbUJBQW1CLEVBQ25CLElBQUksQ0FBQyxpQkFBaUIsQ0FDdkIsQ0FBQztTQUNIO2FBQU0sSUFBSSxJQUFJLFlBQVksNEJBQWtCLEVBQUU7WUFDN0MsSUFBSSxDQUFDLGdCQUFnQixDQUNuQixJQUFJLEVBQ0osSUFBSSxDQUFDLHNCQUFzQixFQUMzQixHQUFHLEVBQ0gscUJBQXFCLEVBQ3JCLElBQUksQ0FBQyxtQkFBbUIsQ0FDekIsQ0FBQztTQUNIO0lBQ0gsQ0FBQzs7QUFwR0gsc0RBcUdDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgSUFzcGVjdCwgU3RhY2ssIFRva2VuIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHtcbiAgQ2ZuSW5zdGFuY2VQcm9maWxlLFxuICBDZm5NYW5hZ2VkUG9saWN5LFxuICBDZm5Qb2xpY3ksXG4gIENmblJvbGUsXG59IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgZ2V0UmVzb3VyY2VJZCB9IGZyb20gJy4uL3V0aWxzL3V0aWxzJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIHRvIHBhc3MgdG8gdGhlIEFkZFBlcm1pc3Npb25Cb3VuZGFyeVxuICpcbiAqIEBpbnRlcmZhY2UgQWRkUGVybWlzc2lvbkJvdW5kYXJ5UHJvcHNcbiAqXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQWRkUGVybWlzc2lvbkJvdW5kYXJ5UHJvcHMge1xuICAvKipcbiAgICogTmFtZSBvZiBQZXJtaXNzaW9ucyBCb3VuZGFyeSBQb2xpY3kgdG8gYWRkIHRvIGFsbCBJQU0gcm9sZXNcbiAgICovXG4gIHJlYWRvbmx5IHBlcm1pc3Npb25zQm91bmRhcnlQb2xpY3lOYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBIHByZWZpeCB0byBwcmVwZW5kIHRvIHRoZSBuYW1lIG9mIElBTSBSb2xlcyAoRGVmYXVsdDogJycpLlxuICAgKi9cbiAgcmVhZG9ubHkgcm9sZVByZWZpeD86IHN0cmluZztcbiAgLyoqXG4gICAqIEEgcHJlZml4IHRvIHByZXBlbmQgdG8gdGhlIG5hbWUgb2YgdGhlIElBTSBQb2xpY2llcyBhbmQgTWFuYWdlZFBvbGljaWVzIChEZWZhdWx0OiAnJykuXG4gICAqL1xuICByZWFkb25seSBwb2xpY3lQcmVmaXg/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBIHByZWZpeCB0byBwcmVwZW5kIHRvIHRoZSBuYW1lIG9mIHRoZSBJQU0gSW5zdGFuY2VQcm9maWxlcyAoRGVmYXVsdDogJycpLlxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFuY2VQcm9maWxlUHJlZml4Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIEEgcGF0Y2ggZm9yIEFkZGluZyBQZXJtaXNzaW9ucyBCb3VuZGFyaWVzIHRvIGFsbCBJQU0gcm9sZXNcbiAqXG4gKiBBZGRpdGlvbmFsIG9wdGlvbnMgZm9yIGFkZGluZyBwcmVmaXhlcyB0byBJQU0gcm9sZSwgcG9saWN5IGFuZCBpbnN0YW5jZSBwcm9maWxlIG5hbWVzXG4gKlxuICogQ2FuIGFjY291bnQgZm9yIG5vbiBjb21tZXJjaWFsIHBhcnRpdGlvbnMgKGUuZy4gYXdzLWdvdiwgYXdzLWNuKVxuICovXG5leHBvcnQgY2xhc3MgQWRkUGVybWlzc2lvbkJvdW5kYXJ5IGltcGxlbWVudHMgSUFzcGVjdCB7XG4gIHByaXZhdGUgX3Blcm1pc3Npb25zQm91bmRhcnlQb2xpY3lOYW1lOiBzdHJpbmc7XG4gIHByaXZhdGUgX3JvbGVQcmVmaXg6IHN0cmluZztcbiAgcHJpdmF0ZSBfcG9saWN5UHJlZml4OiBzdHJpbmc7XG4gIHByaXZhdGUgX2luc3RhbmNlUHJvZmlsZVByZWZpeDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBBZGRQZXJtaXNzaW9uQm91bmRhcnlQcm9wcykge1xuICAgIHRoaXMuX3Blcm1pc3Npb25zQm91bmRhcnlQb2xpY3lOYW1lID0gcHJvcHMucGVybWlzc2lvbnNCb3VuZGFyeVBvbGljeU5hbWU7XG4gICAgdGhpcy5fcm9sZVByZWZpeCA9IHByb3BzLnJvbGVQcmVmaXggfHwgJyc7XG4gICAgdGhpcy5fcG9saWN5UHJlZml4ID0gcHJvcHMucG9saWN5UHJlZml4IHx8ICcnO1xuICAgIHRoaXMuX2luc3RhbmNlUHJvZmlsZVByZWZpeCA9IHByb3BzLmluc3RhbmNlUHJvZmlsZVByZWZpeCB8fCAnJztcbiAgfVxuXG4gIHB1YmxpYyBjaGVja0FuZE92ZXJyaWRlKFxuICAgIG5vZGU6IENmblJlc291cmNlLFxuICAgIHByZWZpeDogc3RyaW5nLFxuICAgIGxlbmd0aDogbnVtYmVyLFxuICAgIGNmblByb3A6IHN0cmluZyxcbiAgICBjZGtQcm9wPzogc3RyaW5nXG4gICk6IHZvaWQge1xuICAgIGlmICghY2RrUHJvcD8uc3RhcnRzV2l0aChwcmVmaXgpKSB7XG4gICAgICBpZiAoY2RrUHJvcCAhPSB1bmRlZmluZWQpIHtcbiAgICAgICAgY29uc3QgcG9saWN5U3VmZml4ID0gIVRva2VuLmlzVW5yZXNvbHZlZChjZGtQcm9wKVxuICAgICAgICAgID8gKGNka1Byb3AgYXMgc3RyaW5nKVxuICAgICAgICAgIDogZ2V0UmVzb3VyY2VJZChub2RlLm5vZGUucGF0aCk7XG5cbiAgICAgICAgbm9kZS5hZGRQcm9wZXJ0eU92ZXJyaWRlKFxuICAgICAgICAgIGNmblByb3AsXG4gICAgICAgICAgYCR7cHJlZml4fSR7cG9saWN5U3VmZml4LnJlcGxhY2UoL1xccy9nLCAnJyl9YC5zdWJzdHJpbmcoMCwgbGVuZ3RoIC0gMSlcbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBwdWJsaWMgdmlzaXQobm9kZTogSUNvbnN0cnVjdCk6IHZvaWQge1xuICAgIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUmVzb3VyY2UpIHtcbiAgICAgIGNvbnN0IGNmblJlc291cmNlTm9kZTogQ2ZuUmVzb3VyY2UgPSBub2RlO1xuICAgICAgaWYgKGNmblJlc291cmNlTm9kZS5jZm5SZXNvdXJjZVR5cGUgPT0gJ0FXUzo6SUFNOjpSb2xlJykge1xuICAgICAgICBjb25zdCBwZXJtaXNzaW9uc0JvdW5kYXJ5UG9saWN5QXJuID0gU3RhY2sub2Yobm9kZSkuZm9ybWF0QXJuKHtcbiAgICAgICAgICBzZXJ2aWNlOiAnaWFtJyxcbiAgICAgICAgICByZXNvdXJjZTogJ3BvbGljeScsXG4gICAgICAgICAgcmVnaW9uOiAnJyxcbiAgICAgICAgICByZXNvdXJjZU5hbWU6IHRoaXMuX3Blcm1pc3Npb25zQm91bmRhcnlQb2xpY3lOYW1lLFxuICAgICAgICB9KTtcbiAgICAgICAgbm9kZS5hZGRQcm9wZXJ0eU92ZXJyaWRlKFxuICAgICAgICAgICdQZXJtaXNzaW9uc0JvdW5kYXJ5JyxcbiAgICAgICAgICBwZXJtaXNzaW9uc0JvdW5kYXJ5UG9saWN5QXJuXG4gICAgICAgICk7XG4gICAgICAgIHRoaXMuY2hlY2tBbmRPdmVycmlkZShcbiAgICAgICAgICBub2RlLFxuICAgICAgICAgIHRoaXMuX3JvbGVQcmVmaXgsXG4gICAgICAgICAgNjQsXG4gICAgICAgICAgJ1JvbGVOYW1lJyxcbiAgICAgICAgICBjZm5SZXNvdXJjZU5vZGUubG9naWNhbElkXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuICAgIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUm9sZSkge1xuICAgICAgY29uc3QgcGVybWlzc2lvbnNCb3VuZGFyeVBvbGljeUFybiA9IFN0YWNrLm9mKG5vZGUpLmZvcm1hdEFybih7XG4gICAgICAgIHNlcnZpY2U6ICdpYW0nLFxuICAgICAgICByZXNvdXJjZTogJ3BvbGljeScsXG4gICAgICAgIHJlZ2lvbjogJycsXG4gICAgICAgIHJlc291cmNlTmFtZTogdGhpcy5fcGVybWlzc2lvbnNCb3VuZGFyeVBvbGljeU5hbWUsXG4gICAgICB9KTtcbiAgICAgIG5vZGUuYWRkUHJvcGVydHlPdmVycmlkZShcbiAgICAgICAgJ1Blcm1pc3Npb25zQm91bmRhcnknLFxuICAgICAgICBwZXJtaXNzaW9uc0JvdW5kYXJ5UG9saWN5QXJuXG4gICAgICApO1xuICAgICAgdGhpcy5jaGVja0FuZE92ZXJyaWRlKFxuICAgICAgICBub2RlLFxuICAgICAgICB0aGlzLl9yb2xlUHJlZml4LFxuICAgICAgICA2NCxcbiAgICAgICAgJ1JvbGVOYW1lJyxcbiAgICAgICAgbm9kZS5yb2xlTmFtZVxuICAgICAgKTtcbiAgICB9IGVsc2UgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5Qb2xpY3kpIHtcbiAgICAgIHRoaXMuY2hlY2tBbmRPdmVycmlkZShcbiAgICAgICAgbm9kZSxcbiAgICAgICAgdGhpcy5fcG9saWN5UHJlZml4LFxuICAgICAgICAxMjgsXG4gICAgICAgICdQb2xpY3lOYW1lJyxcbiAgICAgICAgbm9kZS5wb2xpY3lOYW1lXG4gICAgICApO1xuICAgIH0gZWxzZSBpZiAobm9kZSBpbnN0YW5jZW9mIENmbk1hbmFnZWRQb2xpY3kpIHtcbiAgICAgIHRoaXMuY2hlY2tBbmRPdmVycmlkZShcbiAgICAgICAgbm9kZSxcbiAgICAgICAgdGhpcy5fcG9saWN5UHJlZml4LFxuICAgICAgICAxMjgsXG4gICAgICAgICdNYW5hZ2VkUG9saWN5TmFtZScsXG4gICAgICAgIG5vZGUubWFuYWdlZFBvbGljeU5hbWVcbiAgICAgICk7XG4gICAgfSBlbHNlIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuSW5zdGFuY2VQcm9maWxlKSB7XG4gICAgICB0aGlzLmNoZWNrQW5kT3ZlcnJpZGUoXG4gICAgICAgIG5vZGUsXG4gICAgICAgIHRoaXMuX2luc3RhbmNlUHJvZmlsZVByZWZpeCxcbiAgICAgICAgMTI4LFxuICAgICAgICAnSW5zdGFuY2VQcm9maWxlTmFtZScsXG4gICAgICAgIG5vZGUuaW5zdGFuY2VQcm9maWxlTmFtZVxuICAgICAgKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==