"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConvertInlinePoliciesToManaged = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Patch for turning all Policies into ConvertInlinePoliciesToManaged
 *
 * Some users have policies in place that make it impossible to create inline policies. Instead,
 * they must use managed policies.
 *
 * Note that order matters with this aspect. Specifically, it should generally be added first.
 * This is because other aspects may add overrides that would be lost if applied before
 * this aspect since the original aspect is removed and replaced.
 *
 * @example
 * // Replace all AWS::IAM::Policy resources with equivalent AWS::IAM::ManagedPolicy
 * Aspects.of(stack).add(new ConvertInlinePoliciesToManaged())
 */
class ConvertInlinePoliciesToManaged {
    visit(node) {
        if (node instanceof aws_cdk_lib_1.aws_iam.CfnPolicy) {
            const logicalId = node.stack.resolve(node.logicalId);
            const policyDocument = node.stack.resolve(node.policyDocument);
            const parent = node.node?.scope?.node;
            parent?.tryRemoveChild(node.node.id);
            const resource = new aws_cdk_lib_1.aws_iam.CfnManagedPolicy(node.stack, logicalId, {
                managedPolicyName: node.stack.resolve(node.policyName),
                groups: node.groups,
                roles: node.roles,
                policyDocument,
            });
            const overrides = node.rawOverrides;
            if (overrides?.Properties?.PolicyName) {
                resource.addPropertyOverride('ManagedPolicyName', overrides?.Properties?.PolicyName);
            }
        }
    }
}
exports.ConvertInlinePoliciesToManaged = ConvertInlinePoliciesToManaged;
_a = JSII_RTTI_SYMBOL_1;
ConvertInlinePoliciesToManaged[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.ConvertInlinePoliciesToManaged", version: "0.0.250" };
//# sourceMappingURL=data:application/json;base64,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