import { Json, FlatJson } from './types';
/**
 * Contains static helper functions to deal with flattening objects,
 * retrieving values from flat objects and setting values on flat objects.
 */
export declare class Flattener {
    /**
     * Flattens a provided Json object, moving all nested objects to the top
     * level and separating with dots, example:
     * ```
     * {
     *   "Stack.Resources.Foo.Properties.Tags.0.Value": "bar"
     * }
     * ```
     *
     * @param obj complex object to flatten
     * @returns key-value pairs of object separated by dots, and the value
     */
    static flattenObject: (obj: Json) => FlatJson;
    /**
     * Retrieves a value from a provided Json object by using the provided flat
     * path to look it up
     *
     * @param obj object to search through
     * @param path string of where in the object to get, separated by dots
     * @returns found value
     */
    static getValueByPath: (obj: Json, path: string) => any;
    /**
     * Updates a value in a provided Json object by using the provided flat
     * path to look it up and the provided value to set
     *
     * @param obj object to update
     * @param path string of path to key to update (separated by dots)
     * @param value value to set in object path
     */
    static setToValue: (obj: Json, path: string, value: any) => void;
}
