"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.bad_input import BadInput
from gams.engine.model.cleanable_job_result_page import CleanableJobResultPage
from gams.engine.model.files_not_found import FilesNotFound
from gams.engine.model.message import Message


class CleanupApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.list_results_endpoint = _Endpoint(
            settings={
                'response_type': (CleanableJobResultPage,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/cleanup/results',
                'operation_id': 'list_results',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'per_page',
                    'order_by',
                    'order_asc',
                    'from_datetime',
                    'to_datetime',
                    'namespace',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'order_by',
                ],
                'validation': [
                    'page',
                    'per_page',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                    ('per_page',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('order_by',): {

                        "FILENAME": "filename",
                        "USERNAME": "username",
                        "NAMESPACE": "namespace",
                        "LENGTH": "length",
                        "UPLOAD_DATE": "upload_date"
                    },
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'per_page':
                        (int,),
                    'order_by':
                        (str,),
                    'order_asc':
                        (bool,),
                    'from_datetime':
                        (datetime,),
                    'to_datetime':
                        (datetime,),
                    'namespace':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'per_page': 'per_page',
                    'order_by': 'order_by',
                    'order_asc': 'order_asc',
                    'from_datetime': 'from_datetime',
                    'to_datetime': 'to_datetime',
                    'namespace': 'namespace',
                },
                'location_map': {
                    'page': 'query',
                    'per_page': 'query',
                    'order_by': 'query',
                    'order_asc': 'query',
                    'from_datetime': 'query',
                    'to_datetime': 'query',
                    'namespace': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_results_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/cleanup/results',
                'operation_id': 'remove_results',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'filename',
                    'token',
                    'hypercube_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filename':
                        ([str],),
                    'token':
                        ([str],),
                    'hypercube_token':
                        ([str],),
                },
                'attribute_map': {
                    'filename': 'filename',
                    'token': 'token',
                    'hypercube_token': 'hypercube_token',
                },
                'location_map': {
                    'filename': 'query',
                    'token': 'query',
                    'hypercube_token': 'query',
                },
                'collection_format_map': {
                    'filename': 'multi',
                    'token': 'multi',
                    'hypercube_token': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def list_results(
        self,
        **kwargs
    ):
        """Lists all job and Hypercube results  # noqa: E501

        Admins can see everyone's results. Inviters can see results of their own jobs as well as jobs of their invitees. Users can only see results of their own jobs. Note that jobs that are shared with the logged in user via access groups are not listed here.  If the page is not one and there are no elements on this page, throws 404.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_results(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): [optional] if omitted the server will use the default value of 1
            per_page (int): [optional] if omitted the server will use the default value of 0
            order_by (str): [optional] if omitted the server will use the default value of "upload_date"
            order_asc (bool): [optional] if omitted the server will use the default value of False
            from_datetime (datetime): iso8601 Datetime to select the results if they are uploaded before.. [optional]
            to_datetime (datetime): iso8601 Datetime to select the results if they are uploaded after.. [optional]
            namespace (str): Filter results by namespace.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CleanableJobResultPage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_results_endpoint.call_with_http_info(**kwargs)

    def remove_results(
        self,
        **kwargs
    ):
        """Deletes job results and Hypercube results  # noqa: E501

        If a submission token is specified, text entries are also deleted. Admins can delete everyone's results. Inviters can delete results of their own jobs as well as jobs of their invitees. Users can only delete results of their own jobs. Note that jobs that are shared with the logged in user via access groups cannot be deleted via this endpoint.  At most 10000 files can be deleted with a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_results(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filename ([str]): [optional]
            token ([str]): [optional]
            hypercube_token ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.remove_results_endpoint.call_with_http_info(**kwargs)

