"""regenerate

Revision ID: 341a4aa2551e
Revises:
Create Date: 2025-05-02 14:18:54.273708

"""

from collections.abc import Sequence
from typing import Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "341a4aa2551e"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "dataset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("slug", sa.String(), nullable=False),
        sa.Column(
            "dataset_type",
            sa.Enum("CMIP6", "CMIP7", "obs4MIPs", "PMPClimatology", name="sourcedatasettype"),
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_dataset")),
        sa.UniqueConstraint("slug", name=op.f("uq_dataset_slug")),
    )
    op.create_table(
        "provider",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("slug", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("version", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_provider")),
        sa.UniqueConstraint("slug", name=op.f("uq_provider_slug")),
    )
    op.create_table(
        "cmip6_dataset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("activity_id", sa.String(), nullable=False),
        sa.Column("branch_method", sa.String(), nullable=True),
        sa.Column("branch_time_in_child", sa.Float(), nullable=True),
        sa.Column("branch_time_in_parent", sa.Float(), nullable=True),
        sa.Column("experiment", sa.String(), nullable=False),
        sa.Column("experiment_id", sa.String(), nullable=False),
        sa.Column("frequency", sa.String(), nullable=False),
        sa.Column("grid", sa.String(), nullable=False),
        sa.Column("grid_label", sa.String(), nullable=False),
        sa.Column("institution_id", sa.String(), nullable=False),
        sa.Column("long_name", sa.String(), nullable=True),
        sa.Column("member_id", sa.String(), nullable=False),
        sa.Column("nominal_resolution", sa.String(), nullable=False),
        sa.Column("parent_activity_id", sa.String(), nullable=True),
        sa.Column("parent_experiment_id", sa.String(), nullable=True),
        sa.Column("parent_source_id", sa.String(), nullable=True),
        sa.Column("parent_time_units", sa.String(), nullable=True),
        sa.Column("parent_variant_label", sa.String(), nullable=True),
        sa.Column("realm", sa.String(), nullable=False),
        sa.Column("product", sa.String(), nullable=False),
        sa.Column("source_id", sa.String(), nullable=False),
        sa.Column("standard_name", sa.String(), nullable=False),
        sa.Column("source_type", sa.String(), nullable=False),
        sa.Column("sub_experiment", sa.String(), nullable=False),
        sa.Column("sub_experiment_id", sa.String(), nullable=False),
        sa.Column("table_id", sa.String(), nullable=False),
        sa.Column("units", sa.String(), nullable=False),
        sa.Column("variable_id", sa.String(), nullable=False),
        sa.Column("variant_label", sa.String(), nullable=False),
        sa.Column("vertical_levels", sa.Integer(), nullable=True),
        sa.Column("version", sa.String(), nullable=False),
        sa.Column("instance_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(["id"], ["dataset.id"], name=op.f("fk_cmip6_dataset_id_dataset")),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_cmip6_dataset")),
    )
    op.create_table(
        "dataset_file",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("end_time", sa.DateTime(), nullable=True),
        sa.Column("start_time", sa.DateTime(), nullable=True),
        sa.Column("path", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["dataset.id"],
            name=op.f("fk_dataset_file_dataset_id_dataset"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_dataset_file")),
    )
    op.create_table(
        "diagnostic",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("slug", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("provider_id", sa.Integer(), nullable=False),
        sa.Column("enabled", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.ForeignKeyConstraint(
            ["provider_id"], ["provider.id"], name=op.f("fk_diagnostic_provider_id_provider")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_diagnostic")),
        sa.UniqueConstraint("provider_id", "slug", name="diagnostic_ident"),
        sa.UniqueConstraint("slug", name=op.f("uq_diagnostic_slug")),
    )
    op.create_table(
        "obs4mips_dataset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("activity_id", sa.String(), nullable=False),
        sa.Column("frequency", sa.String(), nullable=False),
        sa.Column("grid", sa.String(), nullable=False),
        sa.Column("grid_label", sa.String(), nullable=False),
        sa.Column("institution_id", sa.String(), nullable=False),
        sa.Column("long_name", sa.String(), nullable=False),
        sa.Column("nominal_resolution", sa.String(), nullable=False),
        sa.Column("realm", sa.String(), nullable=False),
        sa.Column("product", sa.String(), nullable=False),
        sa.Column("source_id", sa.String(), nullable=False),
        sa.Column("source_type", sa.String(), nullable=False),
        sa.Column("units", sa.String(), nullable=False),
        sa.Column("variable_id", sa.String(), nullable=False),
        sa.Column("variant_label", sa.String(), nullable=False),
        sa.Column("vertical_levels", sa.Integer(), nullable=False),
        sa.Column("source_version_number", sa.String(), nullable=False),
        sa.Column("instance_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(["id"], ["dataset.id"], name=op.f("fk_obs4mips_dataset_id_dataset")),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_obs4mips_dataset")),
    )
    op.create_table(
        "pmp_climatology_dataset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("activity_id", sa.String(), nullable=False),
        sa.Column("frequency", sa.String(), nullable=False),
        sa.Column("grid", sa.String(), nullable=False),
        sa.Column("grid_label", sa.String(), nullable=False),
        sa.Column("institution_id", sa.String(), nullable=False),
        sa.Column("long_name", sa.String(), nullable=False),
        sa.Column("nominal_resolution", sa.String(), nullable=False),
        sa.Column("realm", sa.String(), nullable=False),
        sa.Column("product", sa.String(), nullable=False),
        sa.Column("source_id", sa.String(), nullable=False),
        sa.Column("source_type", sa.String(), nullable=False),
        sa.Column("units", sa.String(), nullable=False),
        sa.Column("variable_id", sa.String(), nullable=False),
        sa.Column("variant_label", sa.String(), nullable=False),
        sa.Column("vertical_levels", sa.Integer(), nullable=False),
        sa.Column("source_version_number", sa.String(), nullable=False),
        sa.Column("instance_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(["id"], ["dataset.id"], name=op.f("fk_pmp_climatology_dataset_id_dataset")),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_pmp_climatology_dataset")),
    )
    op.create_table(
        "execution_group",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("diagnostic_id", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("dirty", sa.Boolean(), nullable=False),
        sa.Column("selectors", sa.JSON(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.ForeignKeyConstraint(
            ["diagnostic_id"], ["diagnostic.id"], name=op.f("fk_execution_group_diagnostic_id_diagnostic")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_execution_group")),
        sa.UniqueConstraint("diagnostic_id", "key", name="execution_ident"),
    )
    with op.batch_alter_table("execution_group", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_execution_group_key"), ["key"], unique=False)

    op.create_table(
        "execution",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("output_fragment", sa.String(), nullable=False),
        sa.Column("execution_group_id", sa.Integer(), nullable=False),
        sa.Column("dataset_hash", sa.String(), nullable=False),
        sa.Column("successful", sa.Boolean(), nullable=True),
        sa.Column("path", sa.String(), nullable=True),
        sa.Column("retracted", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.ForeignKeyConstraint(["execution_group_id"], ["execution_group.id"], name="fk_execution_id"),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_execution")),
    )
    with op.batch_alter_table("execution", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_execution_dataset_hash"), ["dataset_hash"], unique=False)

    op.create_table(
        "execution_dataset",
        sa.Column("execution_id", sa.Integer(), nullable=True),
        sa.Column("dataset_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["dataset_id"], ["dataset.id"], name=op.f("fk_execution_dataset_dataset_id_dataset")
        ),
        sa.ForeignKeyConstraint(
            ["execution_id"], ["execution.id"], name=op.f("fk_execution_dataset_execution_id_execution")
        ),
    )
    op.create_table(
        "execution_output",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("execution_id", sa.Integer(), nullable=False),
        sa.Column("output_type", sa.Enum("Plot", "Data", "HTML", name="resultoutputtype"), nullable=False),
        sa.Column("filename", sa.String(), nullable=True),
        sa.Column("short_name", sa.String(), nullable=True),
        sa.Column("long_name", sa.String(), nullable=True),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.ForeignKeyConstraint(
            ["execution_id"], ["execution.id"], name=op.f("fk_execution_output_execution_id_execution")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_execution_output")),
    )
    with op.batch_alter_table("execution_output", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_execution_output_execution_id"), ["execution_id"], unique=False)
        batch_op.create_index(batch_op.f("ix_execution_output_output_type"), ["output_type"], unique=False)

    op.create_table(
        "metric_value",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("execution_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column("attributes", sa.JSON(), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.ForeignKeyConstraint(
            ["execution_id"], ["execution.id"], name=op.f("fk_metric_value_execution_id_execution")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_metric_value")),
    )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("metric_value")
    with op.batch_alter_table("execution_output", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_execution_output_output_type"))
        batch_op.drop_index(batch_op.f("ix_execution_output_execution_id"))

    op.drop_table("execution_output")
    op.drop_table("execution_dataset")
    with op.batch_alter_table("execution", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_execution_dataset_hash"))

    op.drop_table("execution")
    with op.batch_alter_table("execution_group", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_execution_group_key"))

    op.drop_table("execution_group")
    op.drop_table("pmp_climatology_dataset")
    op.drop_table("obs4mips_dataset")
    op.drop_table("diagnostic")
    op.drop_table("dataset_file")
    op.drop_table("cmip6_dataset")
    op.drop_table("provider")
    op.drop_table("dataset")
    # ### end Alembic commands ###
