"""series-metric-value

Revision ID: 03dbb4998e49
Revises: 341a4aa2551e
Create Date: 2025-05-09 20:32:08.664426

"""

from collections.abc import Sequence
from typing import Union

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "03dbb4998e49"
down_revision: Union[str, None] = "341a4aa2551e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("metric_value", schema=None) as batch_op:
        batch_op.add_column(sa.Column("values", sa.JSON(), nullable=True))
        batch_op.add_column(sa.Column("index", sa.JSON(), nullable=True))
        batch_op.add_column(sa.Column("index_name", sa.String(), nullable=True))
        batch_op.alter_column("value", existing_type=sa.FLOAT(), nullable=True)

    if sa.inspect(op.get_bind()).dialect.name == "postgresql":
        sa.Enum("SCALAR", "SERIES", name="metricvaluetype").create(op.get_bind())
        op.add_column(
            "metric_value",
            sa.Column(
                "type",
                postgresql.ENUM("SCALAR", "SERIES", name="metricvaluetype", create_type=False),
                nullable=False,
            ),
        )
    else:
        with op.batch_alter_table("metric_value", schema=None) as batch_op:
            batch_op.add_column(
                sa.Column("type", sa.Enum("SCALAR", "SERIES", name="metricvaluetype"), nullable=False)
            )


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("metric_value", schema=None) as batch_op:
        batch_op.alter_column("value", existing_type=sa.FLOAT(), nullable=False)
        batch_op.drop_column("index_name")
        batch_op.drop_column("index")
        batch_op.drop_column("values")
        batch_op.drop_column("type")

    # ### end Alembic commands ###
