"""Drop unique requirement on slug

Revision ID: 795c1e6cf496
Revises: 03dbb4998e49
Create Date: 2025-07-03 15:05:28.517124

"""

from collections.abc import Sequence
from typing import Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "795c1e6cf496"
down_revision: Union[str, None] = "03dbb4998e49"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("diagnostic", schema=None) as batch_op:
        batch_op.drop_constraint("uq_diagnostic_slug", type_="unique")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("diagnostic", schema=None) as batch_op:
        batch_op.create_unique_constraint("uq_diagnostic_slug", ["slug"])

    # ### end Alembic commands ###
