"""cmip6-finalised

Revision ID: 94beace57a9c
Revises: 795c1e6cf496
Create Date: 2025-07-20 15:21:17.132458

"""

from collections.abc import Sequence
from typing import Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "94beace57a9c"
down_revision: Union[str, None] = "795c1e6cf496"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("cmip6_dataset", schema=None) as batch_op:
        batch_op.add_column(sa.Column("finalised", sa.Boolean(), nullable=False))
        batch_op.alter_column("experiment", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("frequency", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("grid", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("nominal_resolution", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("realm", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("product", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("standard_name", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("source_type", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("sub_experiment", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("sub_experiment_id", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("units", existing_type=sa.VARCHAR(), nullable=True)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("cmip6_dataset", schema=None) as batch_op:
        batch_op.alter_column("units", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("sub_experiment_id", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("sub_experiment", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("source_type", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("standard_name", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("product", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("realm", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("nominal_resolution", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("grid", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("frequency", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("experiment", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.drop_column("finalised")

    # ### end Alembic commands ###
