# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from revengai.models.elf_dynamic_entry import ElfDynamicEntry
from revengai.models.elf_import_model import ELFImportModel
from revengai.models.elf_relocation import ELFRelocation
from revengai.models.elf_section import ELFSection
from revengai.models.elf_security import ELFSecurity
from revengai.models.elf_segment import ELFSegment
from revengai.models.elf_symbol import ELFSymbol
from typing import Optional, Set
from typing_extensions import Self

class ELFModel(BaseModel):
    """
    ELFModel
    """ # noqa: E501
    file_type: StrictStr
    architecture: StrictStr
    endianness: StrictStr
    entry_point: StrictInt
    entry_point_bytes: StrictStr
    import_hash: StrictStr
    export_hash: StrictStr
    build_id: StrictStr
    security: ELFSecurity
    sections: List[ELFSection]
    segments: List[ELFSegment]
    symbols: List[ELFSymbol]
    dynamic_symbols: List[ELFSymbol]
    relocations: List[ELFRelocation]
    imports: ELFImportModel
    exported_functions: List[StrictStr]
    dynamic_entries: List[ElfDynamicEntry]
    notes: List[Dict[str, Any]]
    debug_info: Dict[str, Any]
    version_info: Dict[str, Any]
    __properties: ClassVar[List[str]] = ["file_type", "architecture", "endianness", "entry_point", "entry_point_bytes", "import_hash", "export_hash", "build_id", "security", "sections", "segments", "symbols", "dynamic_symbols", "relocations", "imports", "exported_functions", "dynamic_entries", "notes", "debug_info", "version_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ELFModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sections (list)
        _items = []
        if self.sections:
            for _item_sections in self.sections:
                if _item_sections:
                    _items.append(_item_sections.to_dict())
            _dict['sections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in segments (list)
        _items = []
        if self.segments:
            for _item_segments in self.segments:
                if _item_segments:
                    _items.append(_item_segments.to_dict())
            _dict['segments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in symbols (list)
        _items = []
        if self.symbols:
            for _item_symbols in self.symbols:
                if _item_symbols:
                    _items.append(_item_symbols.to_dict())
            _dict['symbols'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dynamic_symbols (list)
        _items = []
        if self.dynamic_symbols:
            for _item_dynamic_symbols in self.dynamic_symbols:
                if _item_dynamic_symbols:
                    _items.append(_item_dynamic_symbols.to_dict())
            _dict['dynamic_symbols'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relocations (list)
        _items = []
        if self.relocations:
            for _item_relocations in self.relocations:
                if _item_relocations:
                    _items.append(_item_relocations.to_dict())
            _dict['relocations'] = _items
        # override the default output from pydantic by calling `to_dict()` of imports
        if self.imports:
            _dict['imports'] = self.imports.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dynamic_entries (list)
        _items = []
        if self.dynamic_entries:
            for _item_dynamic_entries in self.dynamic_entries:
                if _item_dynamic_entries:
                    _items.append(_item_dynamic_entries.to_dict())
            _dict['dynamic_entries'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ELFModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "file_type": obj.get("file_type"),
            "architecture": obj.get("architecture"),
            "endianness": obj.get("endianness"),
            "entry_point": obj.get("entry_point"),
            "entry_point_bytes": obj.get("entry_point_bytes"),
            "import_hash": obj.get("import_hash"),
            "export_hash": obj.get("export_hash"),
            "build_id": obj.get("build_id"),
            "security": ELFSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None,
            "sections": [ELFSection.from_dict(_item) for _item in obj["sections"]] if obj.get("sections") is not None else None,
            "segments": [ELFSegment.from_dict(_item) for _item in obj["segments"]] if obj.get("segments") is not None else None,
            "symbols": [ELFSymbol.from_dict(_item) for _item in obj["symbols"]] if obj.get("symbols") is not None else None,
            "dynamic_symbols": [ELFSymbol.from_dict(_item) for _item in obj["dynamic_symbols"]] if obj.get("dynamic_symbols") is not None else None,
            "relocations": [ELFRelocation.from_dict(_item) for _item in obj["relocations"]] if obj.get("relocations") is not None else None,
            "imports": ELFImportModel.from_dict(obj["imports"]) if obj.get("imports") is not None else None,
            "exported_functions": obj.get("exported_functions"),
            "dynamic_entries": [ElfDynamicEntry.from_dict(_item) for _item in obj["dynamic_entries"]] if obj.get("dynamic_entries") is not None else None,
            "notes": obj.get("notes"),
            "debug_info": obj.get("debug_info"),
            "version_info": obj.get("version_info")
        })
        return _obj


