# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GlobalVariable(BaseModel):
    """
    GlobalVariable
    """ # noqa: E501
    last_change: Optional[StrictStr] = None
    addr: StrictInt = Field(description="Memory address of the global variable")
    name: StrictStr = Field(description="Name of the global variable")
    type: StrictStr = Field(description="Data type of the global variable")
    size: StrictInt = Field(description="Size of the global variable in bytes")
    artifact_type: Optional[StrictStr] = Field(default=None, description="Type of artifact that the global variable is associated with")
    __properties: ClassVar[List[str]] = ["last_change", "addr", "name", "type", "size", "artifact_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GlobalVariable from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if last_change (nullable) is None
        # and model_fields_set contains the field
        if self.last_change is None and "last_change" in self.model_fields_set:
            _dict['last_change'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GlobalVariable from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "last_change": obj.get("last_change"),
            "addr": obj.get("addr"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "size": obj.get("size"),
            "artifact_type": obj.get("artifact_type")
        })
        return _obj


