# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.0-rc1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class DockerServiceConnectionRequest(BaseModel):
    """
    DockerServiceConnection Serializer
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    local: Optional[StrictBool] = Field(default=None, description="If enabled, use the local connection. Required Docker socket/Kubernetes Integration")
    url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Can be in the format of 'unix://<path>' when connecting to a local docker daemon, or 'https://<hostname>:2376' when connecting to a remote system.")
    tls_verification: Optional[StrictStr] = Field(default=None, description="CA which the endpoint's Certificate is verified against. Can be left empty for no validation.")
    tls_authentication: Optional[StrictStr] = Field(default=None, description="Certificate/Key used for authentication. Can be left empty for no authentication.")
    __properties: ClassVar[List[str]] = ["name", "local", "url", "tls_verification", "tls_authentication"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DockerServiceConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tls_verification (nullable) is None
        # and model_fields_set contains the field
        if self.tls_verification is None and "tls_verification" in self.model_fields_set:
            _dict['tls_verification'] = None

        # set to None if tls_authentication (nullable) is None
        # and model_fields_set contains the field
        if self.tls_authentication is None and "tls_authentication" in self.model_fields_set:
            _dict['tls_authentication'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DockerServiceConnectionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "local": obj.get("local"),
            "url": obj.get("url"),
            "tls_verification": obj.get("tls_verification"),
            "tls_authentication": obj.get("tls_authentication")
        })
        return _obj


