# Copyright 2024 Cisco Systems, Inc. and its affiliates


from typing import List, Union

from pydantic import Field
from typing_extensions import Annotated

from .cloud_probe import CloudProbeParcel
from .policy_settings import Cflowd, PolicySettingsParcel
from .qos_policy import QosMap, QosPolicyParcel, QosPolicyTarget, QosSchedulers
from .traffic_policy import (
    Action,
    AppListMatch,
    AppqoeOptimization,
    AppqoeOptimizationAction,
    BackupSlaPreferredColorAction,
    CflowdAction,
    CloudProbeAction,
    CloudSaasAction,
    CountAction,
    DestinationDataIpv6PrefixListMatch,
    DestinationDataPrefixListMatch,
    DestinationIpMatch,
    DestinationIpv6Match,
    DestinationPortMatch,
    DestinationRegion,
    DestinationRegionMatch,
    DnsAppListMatch,
    DNSEntryType,
    DnsMatch,
    DNSTypeEntryType,
    DscpMatch,
    EncapType,
    Entry,
    FallbackToRoutingAction,
    Icmp6MessageMatch,
    IcmpMessageMatch,
    LocalTlocList,
    LogAction,
    LossCorrection,
    LossCorrectionAction,
    LossProtectionType,
    Match,
    Nat,
    NatAction,
    NatPoolAction,
    PacketLengthMatch,
    PreferredRemoteColor,
    ProtocolMatch,
    RedirectDns,
    RedirectDnsAction,
    SaasAppListMatch,
    SecureServiceEdgeInstance,
    Sequence,
    SequenceIpType,
    ServiceAreaMatch,
    ServiceAreaValue,
    ServiceChain,
    ServiceChainNumber,
    ServiceTloc,
    ServiceTlocList,
    ServiceType,
    Set,
    SetAction,
    SetDscp,
    SetForwardingClass,
    SetLocalTlocList,
    SetNextHop,
    SetNextHopIpv6,
    SetNextHopLoose,
    SetPolicer,
    SetPreferredColorGroup,
    SetPreferredRemoteColor,
    SetService,
    SetServiceChain,
    SetTloc,
    SetTlocList,
    SetVpn,
    SigAction,
    SlaClass,
    SlaClassAction,
    SourceDataIpv6PrefixListMatch,
    SourceDataPrefixListMatch,
    SourceIpMatch,
    SourceIpv6Match,
    SourcePortMatch,
    Sse,
    SseAction,
    TcpMatch,
    Tloc,
    TLOCColor,
    TrafficCategory,
    TrafficCategoryMatch,
    TrafficClass,
    TrafficClassMatch,
    TrafficPolicyParcel,
    TrafficPolicyTarget,
    TrafficTargetType,
    TrafficToMatch,
)

AnyApplicationPriorityParcel = Annotated[
    Union[
        CloudProbeParcel,
        PolicySettingsParcel,
        QosPolicyParcel,
        TrafficPolicyParcel,
    ],
    Field(discriminator="type_"),
]

__all__ = (
    "Action",
    "AnyApplicationPriorityParcel",
    "AppListMatch",
    "AppqoeOptimization",
    "AppqoeOptimizationAction",
    "BackupSlaPreferredColorAction",
    "Cflowd",
    "CflowdAction",
    "CloudProbeAction",
    "CloudProbeParcel",
    "CloudSaasAction",
    "CountAction",
    "DestinationDataIpv6PrefixListMatch",
    "DestinationDataPrefixListMatch",
    "DestinationIpMatch",
    "DestinationIpv6Match",
    "DestinationPortMatch",
    "DestinationRegion",
    "DestinationRegionMatch",
    "DnsAppListMatch",
    "DNSEntryType",
    "DnsMatch",
    "DNSTypeEntryType",
    "DscpMatch",
    "EncapType",
    "Entry",
    "FallbackToRoutingAction",
    "Icmp6MessageMatch",
    "Icmp6MessageValue",
    "IcmpMessageMatch",
    "IcmpMsg",
    "LocalTlocList",
    "LogAction",
    "LossCorrection",
    "LossCorrectionAction",
    "LossProtectionType",
    "Match",
    "Nat",
    "NatAction",
    "NatPoolAction",
    "PacketLengthMatch",
    "PolicySettingsParcel",
    "PreferredRemoteColor",
    "ProtocolMatch",
    "QosMap",
    "QosPolicyParcel",
    "QosPolicyTarget",
    "QosSchedulers",
    "RedirectDns",
    "RedirectDnsAction",
    "RedirectDnsValue",
    "SaasAppListMatch",
    "SecureServiceEdgeInstance",
    "Sequence",
    "SequenceIpType",
    "ServiceAreaMatch",
    "ServiceAreaValue",
    "ServiceChain",
    "ServiceChainNumber",
    "ServiceTloc",
    "ServiceTlocList",
    "ServiceType",
    "Set",
    "SetAction",
    "SetDscp",
    "SetForwardingClass",
    "SetLocalTlocList",
    "SetNextHop",
    "SetNextHopIpv6",
    "SetNextHopLoose",
    "SetPolicer",
    "SetPreferredColorGroup",
    "SetPreferredRemoteColor",
    "SetService",
    "SetServiceChain",
    "SetTloc",
    "SetTlocList",
    "SetVpn",
    "SigAction",
    "SlaClass",
    "SlaClassAction",
    "SourceDataIpv6PrefixListMatch",
    "SourceDataPrefixListMatch",
    "SourceIpMatch",
    "SourceIpv6Match",
    "SourcePortMatch",
    "Sse",
    "SseAction",
    "TcpMatch",
    "Tloc",
    "TLOCColor",
    "TrafficCategory",
    "TrafficCategoryMatch",
    "TrafficClass",
    "TrafficClassMatch",
    "TrafficPolicyParcel",
    "TrafficPolicyTarget",
    "TrafficPolicyTarget",
    "TrafficTargetType",
    "TrafficToMatch",
)


def __dir__() -> "List[str]":
    return list(__all__)
