# Copyright 2022 Cisco Systems, Inc. and its affiliates

from enum import Enum


class DeviceModel(str, Enum):
    # controlers
    VSMART = "vsmart"
    VBOND = "vedge-cloud"
    VMANAGE = "vmanage"

    # vedges
    VEDGE = "vedge-cloud"
    VEDGE_1000 = "vedge-1000"
    VEDGE_2000 = "vedge-2000"
    VEDGE_100 = "vedge-100"
    VEDGE_100_B = "vedge-100-B"
    VEDGE_100_WM = "vedge-100-WM"
    VEDGE_100_M = "vedge-100-M"
    VEDGE_100_M2 = "vedge-100-M2"
    VEDGE_100_W2 = "vedge-100-W2"
    VEDGE_5000 = "vedge-5000"
    VEDGE_CCM = "vedge-ccm"
    VEDGE_SERVICE_INSERTION = "vedge-service-insertion"

    # ESR
    VEDGE_ESR_6300 = "vedge-ESR-6300"
    VEDGE_ESR_6300_LIC = "vedge-ESR-6300-LIC"
    VEDGE_ESR_6300_LIC_SD_ROUTING = "vedge-ESR-6300-LIC-SD-ROUTING"
    VEDGE_ESR_6300_NCP = "vedge-ESR-6300-NCP"
    VEDGE_ESR_6300_NCP_SD_ROUTING = "vedge-ESR-6300-NCP-SD-ROUTING"
    VEDGE_ESR_6300_SD_ROUTING = "vedge-ESR-6300-SD-ROUTING"

    # IR
    VEDGE_IR_1101 = "vedge-IR-1101"
    VEDGE_IR_1101_SD_ROUTING = "vedge-IR-1101-SD-ROUTING"
    VEDGE_IR_1821 = "vedge-IR-1821"
    VEDGE_IR_1821_SD_ROUTING = "vedge-IR-1821-SD-ROUTING"
    VEDGE_IR_1831 = "vedge-IR-1831"
    VEDGE_IR_1831_SD_ROUTING = "vedge-IR-1831-SD-ROUTING"
    VEDGE_IR_1833 = "vedge-IR-1833"
    VEDGE_IR_1833_SD_ROUTING = "vedge-IR-1833-SD-ROUTING"
    VEDGE_IR_1835 = "vedge-IR-1835"
    VEDGE_IR_1835_SD_ROUTING = "vedge-IR-1835-SD-ROUTING"
    VEDGE_IR_8140H = "vedge-IR-8140H"
    VEDGE_IR_8140H_P = "vedge-IR-8140H-P"
    VEDGE_IR_8140H_P_SD_ROUTING = "vedge-IR-8140H-P-SD-ROUTING"
    VEDGE_IR_8140H_SD_ROUTING = "vedge-IR-8140H-SD-ROUTING"
    VEDGE_IR_8340 = "vedge-IR-8340"
    VEDGE_IR_8340_SD_ROUTING = "vedge-IR-8340-SD-ROUTING"

    # ASR devices
    VEDGE_ASR_1001_HX = "vedge-ASR-1001-HX"
    VEDGE_ASR_1001_HX_SD_ROUTING = "vedge-ASR-1001-HX-SD-ROUTING"
    VEDGE_ASR_1001_X = "vedge-ASR-1001-X"
    VEDGE_ASR_1002_HX = "vedge-ASR-1002-HX"
    VEDGE_ASR_1002_HX_SD_ROUTING = "vedge-ASR-1002-HX-SD-ROUTING"
    VEDGE_ASR_1002_X = "vedge-ASR-1002-X"
    VEDGE_ASR_1006_X = "vedge-ASR-1006-X"

    # CSR
    VEDGE_CSR_1000V = "vedge-CSR-1000v"
    VEDGE_C8000V = "vedge-C8000V"

    # ISR
    VEDGE_ISR_4221 = "vedge-ISR-4221"
    VEDGE_ISR_4221_SD_ROUTING = "vedge-ISR-4221-SD-ROUTING"
    VEDGE_ISR_4221X = "vedge-ISR-4221X"
    VEDGE_ISR_4221X_SD_ROUTING = "vedge-ISR-4221X-SD-ROUTING"
    VEDGE_ISR_4321 = "vedge-ISR-4321"
    VEDGE_ISR_4321_SD_ROUTING = "vedge-ISR-4321-SD-ROUTING"
    VEDGE_ISR_4331 = "vedge-ISR-4331"
    VEDGE_ISR_4331_SD_ROUTING = "vedge-ISR-4331-SD-ROUTING"
    VEDGE_ISR_4351 = "vedge-ISR-4351"
    VEDGE_ISR_4351_SD_ROUTING = "vedge-ISR-4351-SD-ROUTING"
    VEDGE_ISR_4431 = "vedge-ISR-4431"
    VEDGE_ISR_4431_SD_ROUTING = "vedge-ISR-4431-SD-ROUTING"
    VEDGE_ISR_4451_X = "vedge-ISR-4451-X"
    VEDGE_ISR_4451_X_SD_ROUTING = "vedge-ISR-4451-X-SD-ROUTING"
    VEDGE_ISR_4461 = "vedge-ISR-4461"
    VEDGE_ISR_4461_SD_ROUTING = "vedge-ISR-4461-SD-ROUTING"
    VEDGE_ISR1100_4G = "vedge-ISR1100-4G"
    VEDGE_ISR1100_4G_XE = "vedge-ISR1100-4G-XE"
    VEDGE_ISR1100_4GLTE = "vedge-ISR1100-4GLTE"
    VEDGE_ISR1100_4GLTEGB_XE = "vedge-ISR1100-4GLTEGB-XE"
    VEDGE_ISR1100_4GLTENA_XE = "vedge-ISR1100-4GLTENA-XE"
    VEDGE_ISR1100_6G = "vedge-ISR1100-6G"
    VEDGE_ISR1100_6G_XE = "vedge-ISR1100-6G-XE"
    VEDGE_ISR1100X_4G = "vedge-ISR1100X-4G"
    VEDGE_ISR1100X_4G_XE = "vedge-ISR1100X-4G-XE"
    VEDGE_ISR1100X_6G = "vedge-ISR1100X-6G"
    VEDGE_ISR1100X_6G_XE = "vedge-ISR1100X-6G-XE"
    VEDGE_ISRv = "vedge-ISRv"

    # C11x
    VEDGE_C1100TG_1N24P32A_SD_ROUTING = "vedge-C1100TG-1N24P32A-SD-ROUTING"
    VEDGE_C1100TGX_1N24P32A_SD_ROUTING = "vedge-C1100TGX-1N24P32A-SD-ROUTING"
    VEDGE_C1101_4P = "vedge-C1101-4P"
    VEDGE_C1101_4P_SD_ROUTING = "vedge-C1101-4P-SD-ROUTING"
    VEDGE_C1101_4PLTEP = "vedge-C1101-4PLTEP"
    VEDGE_C1101_4PLTEP_SD_ROUTING = "vedge-C1101-4PLTEP-SD-ROUTING"
    VEDGE_C1101_4PLTEPW = "vedge-C1101-4PLTEPW"
    VEDGE_C1101_4PLTEPW_SD_ROUTING = "vedge-C1101-4PLTEPW-SD-ROUTING"
    VEDGE_C1109_2PLTEGB = "vedge-C1109-2PLTEGB"
    VEDGE_C1109_2PLTEGB_SD_ROUTING = "vedge-C1109-2PLTEGB-SD-ROUTING"
    VEDGE_C1109_2PLTEUS = "vedge-C1109-2PLTEUS"
    VEDGE_C1109_2PLTEUS_SD_ROUTING = "vedge-C1109-2PLTEUS-SD-ROUTING"
    VEDGE_C1109_2PLTEVZ = "vedge-C1109-2PLTEVZ"
    VEDGE_C1109_2PLTEVZ_SD_ROUTING = "vedge-C1109-2PLTEVZ-SD-ROUTING"
    VEDGE_C1109_4PLTE2P = "vedge-C1109-4PLTE2P"
    VEDGE_C1109_4PLTE2P_SD_ROUTING = "vedge-C1109-4PLTE2P-SD-ROUTING"
    VEDGE_C1109_4PLTE2PW = "vedge-C1109-4PLTE2PW"
    VEDGE_C1109_4PLTE2PW_SD_ROUTING = "vedge-C1109-4PLTE2PW-SD-ROUTING"
    VEDGE_C1111_4P = "vedge-C1111-4P"
    VEDGE_C1111_4P_SD_ROUTING = "vedge-C1111-4P-SD-ROUTING"
    VEDGE_C1111_4PLTEEA = "vedge-C1111-4PLTEEA"
    VEDGE_C1111_4PLTEEA_SD_ROUTING = "vedge-C1111-4PLTEEA-SD-ROUTING"
    VEDGE_C1111_4PLTELA = "vedge-C1111-4PLTELA"
    VEDGE_C1111_4PLTELA_SD_ROUTING = "vedge-C1111-4PLTELA-SD-ROUTING"
    VEDGE_C1111_4PW = "vedge-C1111-4PW"
    VEDGE_C1111_4PW_SD_ROUTING = "vedge-C1111-4PW-SD-ROUTING"
    VEDGE_C1111_8P = "vedge-C1111-8P"
    VEDGE_C1111_8P_SD_ROUTING = "vedge-C1111-8P-SD-ROUTING"
    VEDGE_C1111_8PLTEEA = "vedge-C1111-8PLTEEA"
    VEDGE_C1111_8PLTEEA_SD_ROUTING = "vedge-C1111-8PLTEEA-SD-ROUTING"
    VEDGE_C1111_8PLTEEAW = "vedge-C1111-8PLTEEAW"
    VEDGE_C1111_8PLTEEAW_SD_ROUTING = "vedge-C1111-8PLTEEAW-SD-ROUTING"
    VEDGE_C1111_8PLTELA = "vedge-C1111-8PLTELA"
    VEDGE_C1111_8PLTELA_SD_ROUTING = "vedge-C1111-8PLTELA-SD-ROUTING"
    VEDGE_C1111_8PLTELAW = "vedge-C1111-8PLTELAW"
    VEDGE_C1111_8PLTELAW_SD_ROUTING = "vedge-C1111-8PLTELAW-SD-ROUTING"
    VEDGE_C1111_8PW = "vedge-C1111-8PW"
    VEDGE_C1111_8PW_SD_ROUTING = "vedge-C1111-8PW-SD-ROUTING"
    VEDGE_C1111X_8P = "vedge-C1111X-8P"
    VEDGE_C1111X_8P_SD_ROUTING = "vedge-C1111X-8P-SD-ROUTING"
    VEDGE_C1112_8P = "vedge-C1112-8P"
    VEDGE_C1112_8P_SD_ROUTING = "vedge-C1112-8P-SD-ROUTING"
    VEDGE_C1112_8PLTEEA = "vedge-C1112-8PLTEEA"
    VEDGE_C1112_8PLTEEA_SD_ROUTING = "vedge-C1112-8PLTEEA-SD-ROUTING"
    VEDGE_C1112_8PLTEEAWE = "vedge-C1112-8PLTEEAWE"
    VEDGE_C1112_8PLTEEAWE_SD_ROUTING = "vedge-C1112-8PLTEEAWE-SD-ROUTING"
    VEDGE_C1112_8PWE = "vedge-C1112-8PWE"
    VEDGE_C1112_8PWE_SD_ROUTING = "vedge-C1112-8PWE-SD-ROUTING"
    VEDGE_C1113_8P = "vedge-C1113-8P"
    VEDGE_C1113_8P_SD_ROUTING = "vedge-C1113-8P-SD-ROUTING"
    VEDGE_C1113_8PLTEEA = "vedge-C1113-8PLTEEA"
    VEDGE_C1113_8PLTEEA_SD_ROUTING = "vedge-C1113-8PLTEEA-SD-ROUTING"
    VEDGE_C1113_8PLTEEAW = "vedge-C1113-8PLTEEAW"
    VEDGE_C1113_8PLTEEAW_SD_ROUTING = "vedge-C1113-8PLTEEAW-SD-ROUTING"
    VEDGE_C1113_8PLTELA = "vedge-C1113-8PLTELA"
    VEDGE_C1113_8PLTELA_SD_ROUTING = "vedge-C1113-8PLTELA-SD-ROUTING"
    VEDGE_C1113_8PLTELAWZ = "vedge-C1113-8PLTELAWZ"
    VEDGE_C1113_8PLTELAWZ_SD_ROUTING = "vedge-C1113-8PLTELAWZ-SD-ROUTING"
    VEDGE_C1113_8PLTEW = "vedge-C1113-8PLTEW"
    VEDGE_C1113_8PLTEW_SD_ROUTING = "vedge-C1113-8PLTEW-SD-ROUTING"
    VEDGE_C1113_8PM = "vedge-C1113-8PM"
    VEDGE_C1113_8PM_SD_ROUTING = "vedge-C1113-8PM-SD-ROUTING"
    VEDGE_C1113_8PMLTEEA = "vedge-C1113-8PMLTEEA"
    VEDGE_C1113_8PMLTEEA_SD_ROUTING = "vedge-C1113-8PMLTEEA-SD-ROUTING"
    VEDGE_C1113_8PMWE = "vedge-C1113-8PMWE"
    VEDGE_C1113_8PMWE_SD_ROUTING = "vedge-C1113-8PMWE-SD-ROUTING"
    VEDGE_C1113_8PW = "vedge-C1113-8PW"
    VEDGE_C1113_8PW_SD_ROUTING = "vedge-C1113-8PW-SD-ROUTING"
    VEDGE_C1116_4P = "vedge-C1116-4P"
    VEDGE_C1116_4P_SD_ROUTING = "vedge-C1116-4P-SD-ROUTING"
    VEDGE_C1116_4PLTEEA = "vedge-C1116-4PLTEEA"
    VEDGE_C1116_4PLTEEA_SD_ROUTING = "vedge-C1116-4PLTEEA-SD-ROUTING"
    VEDGE_C1116_4PLTEEAWE = "vedge-C1116-4PLTEEAWE"
    VEDGE_C1116_4PLTEEAWE_SD_ROUTING = "vedge-C1116-4PLTEEAWE-SD-ROUTING"
    VEDGE_C1116_4PWE = "vedge-C1116-4PWE"
    VEDGE_C1116_4PWE_SD_ROUTING = "vedge-C1116-4PWE-SD-ROUTING"
    VEDGE_C1117_4P = "vedge-C1117-4P"
    VEDGE_C1117_4P_SD_ROUTING = "vedge-C1117-4P-SD-ROUTING"
    VEDGE_C1117_4PLTEEA = "vedge-C1117-4PLTEEA"
    VEDGE_C1117_4PLTEEA_SD_ROUTING = "vedge-C1117-4PLTEEA-SD-ROUTING"
    VEDGE_C1117_4PLTEEAW = "vedge-C1117-4PLTEEAW"
    VEDGE_C1117_4PLTEEAW_SD_ROUTING = "vedge-C1117-4PLTEEAW-SD-ROUTING"
    VEDGE_C1117_4PLTELA = "vedge-C1117-4PLTELA"
    VEDGE_C1117_4PLTELA_SD_ROUTING = "vedge-C1117-4PLTELA-SD-ROUTING"
    VEDGE_C1117_4PLTELAWZ = "vedge-C1117-4PLTELAWZ"
    VEDGE_C1117_4PLTELAWZ_SD_ROUTING = "vedge-C1117-4PLTELAWZ-SD-ROUTING"
    VEDGE_C1117_4PM = "vedge-C1117-4PM"
    VEDGE_C1117_4PM_SD_ROUTING = "vedge-C1117-4PM-SD-ROUTING"
    VEDGE_C1117_4PMLTEEA = "vedge-C1117-4PMLTEEA"
    VEDGE_C1117_4PMLTEEA_SD_ROUTING = "vedge-C1117-4PMLTEEA-SD-ROUTING"
    VEDGE_C1117_4PMLTEEAWE = "vedge-C1117-4PMLTEEAWE"
    VEDGE_C1117_4PMLTEEAWE_SD_ROUTING = "vedge-C1117-4PMLTEEAWE-SD-ROUTING"
    VEDGE_C1117_4PMWE = "vedge-C1117-4PMWE"
    VEDGE_C1117_4PMWE_SD_ROUTING = "vedge-C1117-4PMWE-SD-ROUTING"
    VEDGE_C1117_4PW = "vedge-C1117-4PW"
    VEDGE_C1117_4PW_SD_ROUTING = "vedge-C1117-4PW-SD-ROUTING"
    VEDGE_C1118_8P = "vedge-C1118-8P"
    VEDGE_C1118_8P_SD_ROUTING = "vedge-C1118-8P-SD-ROUTING"
    VEDGE_C1121_4P = "vedge-C1121-4P"
    VEDGE_C1121_4P_SD_ROUTING = "vedge-C1121-4P-SD-ROUTING"
    VEDGE_C1121_4PLTEP = "vedge-C1121-4PLTEP"
    VEDGE_C1121_4PLTEP_SD_ROUTING = "vedge-C1121-4PLTEP-SD-ROUTING"
    VEDGE_C1121_8P = "vedge-C1121-8P"
    VEDGE_C1121_8P_SD_ROUTING = "vedge-C1121-8P-SD-ROUTING"
    VEDGE_C1121_8PLTEP = "vedge-C1121-8PLTEP"
    VEDGE_C1121_8PLTEP_SD_ROUTING = "vedge-C1121-8PLTEP-SD-ROUTING"
    VEDGE_C1121_8PLTEPW = "vedge-C1121-8PLTEPW"
    VEDGE_C1121_8PLTEPW_SD_ROUTING = "vedge-C1121-8PLTEPW-SD-ROUTING"
    VEDGE_C1121X_8P = "vedge-C1121X-8P"
    VEDGE_C1121X_8P_SD_ROUTING = "vedge-C1121X-8P-SD-ROUTING"
    VEDGE_C1121X_8PLTEP = "vedge-C1121X-8PLTEP"
    VEDGE_C1121X_8PLTEP_SD_ROUTING = "vedge-C1121X-8PLTEP-SD-ROUTING"
    VEDGE_C1121X_8PLTEPW = "vedge-C1121X-8PLTEPW"
    VEDGE_C1121X_8PLTEPW_SD_ROUTING = "vedge-C1121X-8PLTEPW-SD-ROUTING"
    VEDGE_C1126_8PLTEP = "vedge-C1126-8PLTEP"
    VEDGE_C1126_8PLTEP_SD_ROUTING = "vedge-C1126-8PLTEP-SD-ROUTING"
    VEDGE_C1126X_8PLTEP = "vedge-C1126X-8PLTEP"
    VEDGE_C1126X_8PLTEP_SD_ROUTING = "vedge-C1126X-8PLTEP-SD-ROUTING"
    VEDGE_C1127_8PLTEP = "vedge-C1127-8PLTEP"
    VEDGE_C1127_8PLTEP_SD_ROUTING = "vedge-C1127-8PLTEP-SD-ROUTING"
    VEDGE_C1127_8PMLTEP = "vedge-C1127-8PMLTEP"
    VEDGE_C1127_8PMLTEP_SD_ROUTING = "vedge-C1127-8PMLTEP-SD-ROUTING"
    VEDGE_C1127X_8PLTEP = "vedge-C1127X-8PLTEP"
    VEDGE_C1127X_8PLTEP_SD_ROUTING = "vedge-C1127X-8PLTEP-SD-ROUTING"
    VEDGE_C1127X_8PMLTEP = "vedge-C1127X-8PMLTEP"
    VEDGE_C1127X_8PMLTEP_SD_ROUTING = "vedge-C1127X-8PMLTEP-SD-ROUTING"
    VEDGE_C1128_8PLTEP = "vedge-C1128-8PLTEP"
    VEDGE_C1128_8PLTEP_SD_ROUTING = "vedge-C1128-8PLTEP-SD-ROUTING"
    VEDGE_C1131_8PLTEPW = "vedge-C1131-8PLTEPW"
    VEDGE_C1131_8PLTEPW_SD_ROUTING = "vedge-C1131-8PLTEPW-SD-ROUTING"
    VEDGE_C1131_8PW = "vedge-C1131-8PW"
    VEDGE_C1131_8PW_SD_ROUTING = "vedge-C1131-8PW-SD-ROUTING"
    VEDGE_C1131X_8PLTEPW = "vedge-C1131X-8PLTEPW"
    VEDGE_C1131X_8PLTEPW_SD_ROUTING = "vedge-C1131X-8PLTEPW-SD-ROUTING"
    VEDGE_C1131X_8PW = "vedge-C1131X-8PW"
    VEDGE_C1131X_8PW_SD_ROUTING = "vedge-C1131X-8PW-SD-ROUTING"
    VEDGE_C1161_8P = "vedge-C1161-8P"
    VEDGE_C1161_8P_SD_ROUTING = "vedge-C1161-8P-SD-ROUTING"
    VEDGE_C1161_8PLTEP = "vedge-C1161-8PLTEP"
    VEDGE_C1161_8PLTEP_SD_ROUTING = "vedge-C1161-8PLTEP-SD-ROUTING"
    VEDGE_C1161X_8P = "vedge-C1161X-8P"
    VEDGE_C1161X_8P_SD_ROUTING = "vedge-C1161X-8P-SD-ROUTING"
    VEDGE_C1161X_8PLTEP = "vedge-C1161X-8PLTEP"
    VEDGE_C1161X_8PLTEP_SD_ROUTING = "vedge-C1161X-8PLTEP-SD-ROUTING"

    # C8xxx
    VEDGE_C8000V_SD_ROUTING = "vedge-C8000V-SD-ROUTING"
    VEDGE_C8131_5T1S = "vedge-C8131-5T1S"
    VEDGE_C8131_5T1S_SD_ROUTING = "vedge-C8131-5T1S-SD-ROUTING"
    VEDGE_C8131_8T2S = "vedge-C8131-8T2S"
    VEDGE_C8131_8T2S_SD_ROUTING = "vedge-C8131-8T2S-SD-ROUTING"
    VEDGE_C8131X_1C_8P2S = "vedge-C8131X-1C-8P2S"
    VEDGE_C8131X_1C_8P2S_SD_ROUTING = "vedge-C8131X-1C-8P2S-SD-ROUTING"
    VEDGE_C8131X_1C_8T2S = "vedge-C8131X-1C-8T2S"
    VEDGE_C8131X_1C_8T2S_SD_ROUTING = "vedge-C8131X-1C-8T2S-SD-ROUTING"
    VEDGE_C8200_1N_4T = "vedge-C8200-1N-4T"
    VEDGE_C8200_1N_4T_SD_ROUTING = "vedge-C8200-1N-4T-SD-ROUTING"
    VEDGE_C8200L_1N_4T = "vedge-C8200L-1N-4T"
    VEDGE_C8200L_1N_4T_SD_ROUTING = "vedge-C8200L-1N-4T-SD-ROUTING"
    VEDGE_C8230_1N_2M2X = "vedge-C8230-1N-2M2X"
    VEDGE_C8230_1N_2M2X_SD_ROUTING = "vedge-C8230-1N-2M2X-SD-ROUTING"
    VEDGE_C8230E_8TM2X = "vedge-C8230E-8TM2X"
    VEDGE_C8230E_8TM2X_SD_ROUTING = "vedge-C8230E-8TM2X-SD-ROUTING"
    VEDGE_C8230X_1N_2M2X = "vedge-C8230X-1N-2M2X"
    VEDGE_C8230X_1N_2M2X_SD_ROUTING = "vedge-C8230X-1N-2M2X-SD-ROUTING"
    VEDGE_C8230X_8M2X = "vedge-C8230X-8M2X"
    VEDGE_C8230X_8M2X_SD_ROUTING = "vedge-C8230X-8M2X-SD-ROUTING"
    VEDGE_C8300_1N1S_4T2X = "vedge-C8300-1N1S-4T2X"
    VEDGE_C8300_1N1S_4T2X_SD_ROUTING = "vedge-C8300-1N1S-4T2X-SD-ROUTING"
    VEDGE_C8300_1N1S_6T = "vedge-C8300-1N1S-6T"
    VEDGE_C8300_1N1S_6T_SD_ROUTING = "vedge-C8300-1N1S-6T-SD-ROUTING"
    VEDGE_C8300_2N2S_4G2X = "vedge-C8300-2N2S-4G2X"
    VEDGE_C8300_2N2S_4T2X = "vedge-C8300-2N2S-4T2X"
    VEDGE_C8300_2N2S_4T2X_SD_ROUTING = "vedge-C8300-2N2S-4T2X-SD-ROUTING"
    VEDGE_C8300_2N2S_6T = "vedge-C8300-2N2S-6T"
    VEDGE_C8300_2N2S_6T_SD_ROUTING = "vedge-C8300-2N2S-6T-SD-ROUTING"
    VEDGE_C8500_12X = "vedge-C8500-12X"
    VEDGE_C8500_12X_SD_ROUTING = "vedge-C8500-12X-SD-ROUTING"
    VEDGE_C8500_12X4QC = "vedge-C8500-12X4QC"
    VEDGE_C8500_12X4QC_SD_ROUTING = "vedge-C8500-12X4QC-SD-ROUTING"
    VEDGE_C8500_20X6C = "vedge-C8500-20X6C"
    VEDGE_C8500_20X6C_SD_ROUTING = "vedge-C8500-20X6C-SD-ROUTING"
    VEDGE_C8500L_8S2X2Y = "vedge-C8500L-8S2X2Y"
    VEDGE_C8500L_8S4X = "vedge-C8500L-8S4X"
    VEDGE_C8500L_8S4X_SD_ROUTING = "vedge-C8500L-8S4X-SD-ROUTING"
    VEDGE_C8500L_8S8X4Y = "vedge-C8500L-8S8X4Y"
    VEDGE_C9500_40X = "vedge-C9500-40X"
    VEDGE_C9500_48Y4C = "vedge-C9500-48Y4C"

    # ISRv
    VEDGE_ISRV = "vedge-ISRv"

    # CELLULAR GATEWAY
    CELLULAR_GATEWAY_CG113_4GW6A = "cellular-gateway-CG113-4GW6A"
    CELLULAR_GATEWAY_CG113_4GW6B = "cellular-gateway-CG113-4GW6B"
    CELLULAR_GATEWAY_CG113_4GW6E = "cellular-gateway-CG113-4GW6E"
    CELLULAR_GATEWAY_CG113_4GW6H = "cellular-gateway-CG113-4GW6H"
    CELLULAR_GATEWAY_CG113_4GW6Q = "cellular-gateway-CG113-4GW6Q"
    CELLULAR_GATEWAY_CG113_4GW6Z = "cellular-gateway-CG113-4GW6Z"
    CELLULAR_GATEWAY_CG113_W6A = "cellular-gateway-CG113-W6A"
    CELLULAR_GATEWAY_CG113_W6B = "cellular-gateway-CG113-W6B"
    CELLULAR_GATEWAY_CG113_W6E = "cellular-gateway-CG113-W6E"
    CELLULAR_GATEWAY_CG113_W6H = "cellular-gateway-CG113-W6H"
    CELLULAR_GATEWAY_CG113_W6Q = "cellular-gateway-CG113-W6Q"
    CELLULAR_GATEWAY_CG113_W6Z = "cellular-gateway-CG113-W6Z"
    CELLULAR_GATEWAY_CG418_E = "cellular-gateway-CG418-E"
    CELLULAR_GATEWAY_CG522_E = "cellular-gateway-CG522-E"

    # NFVIS
    VEDGE_NFVIS_C8200_UCPE = "vedge-nfvis-C8200-UCPE"
    VEDGE_NFVIS_C8200_UCPEVM = "vedge-nfvis-C8200-UCPEVM"
    VEDGE_NFVIS_C8300_UCPE_1N20 = "vedge-nfvis-C8300-UCPE-1N20"
    VEDGE_NFVIS_CSP_5216 = "vedge-nfvis-CSP-5216"
    VEDGE_NFVIS_CSP_5228 = "vedge-nfvis-CSP-5228"
    VEDGE_NFVIS_CSP_5400 = "vedge-nfvis-CSP-5400"
    VEDGE_NFVIS_CSP_5436 = "vedge-nfvis-CSP-5436"
    VEDGE_NFVIS_CSP_5444 = "vedge-nfvis-CSP-5444"
    VEDGE_NFVIS_CSP_5456 = "vedge-nfvis-CSP-5456"
    VEDGE_NFVIS_CSP2100 = "vedge-nfvis-CSP2100"
    VEDGE_NFVIS_CSP2100_X1 = "vedge-nfvis-CSP2100-X1"
    VEDGE_NFVIS_CSP2100_X2 = "vedge-nfvis-CSP2100-X2"
    VEDGE_NFVIS_ENCS5400 = "vedge-nfvis-ENCS5400"
    VEDGE_NFVIS_UCSC_C220_M6S = "vedge-nfvis-UCSC-C220-M6S"
    VEDGE_NFVIS_UCSC_C240_M6S = "vedge-nfvis-UCSC-C240-M6S"
    VEDGE_NFVIS_UCSC_C240_M6SX = "vedge-nfvis-UCSC-C240-M6SX"
    VEDGE_NFVIS_UCSC_E = "vedge-nfvis-UCSC-E"
    VEDGE_NFVIS_UCSC_M5 = "vedge-nfvis-UCSC-M5"
