import * as apigw from '@aws-cdk/aws-apigateway';
import { Construct } from '@aws-cdk/core';
import { IWatchful } from './api';
/**
 * @stability stable
 */
export interface WatchApiGatewayOptions {
    /**
     * Alarm when 5XX errors reach this threshold over 5 minutes.
     *
     * @default 1 any 5xx HTTP response will trigger the alarm
     * @stability stable
     */
    readonly serverErrorThreshold?: number;
    /**
     * A list of operations to monitor separately.
     *
     * @default - only API-level monitoring is added.
     * @stability stable
     */
    readonly watchedOperations?: WatchedOperation[];
    /**
     * Include a dashboard graph for caching metrics.
     *
     * @default false
     * @stability stable
     */
    readonly cacheGraph?: boolean;
}
/**
 * @stability stable
 */
export interface WatchApiGatewayProps extends WatchApiGatewayOptions {
    /**
     * The title of this section.
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * The Watchful instance to add widgets into.
     *
     * @stability stable
     */
    readonly watchful: IWatchful;
    /**
     * The API Gateway REST API that is being watched.
     *
     * @stability stable
     */
    readonly restApi: apigw.RestApi;
}
/**
 * @stability stable
 */
export declare class WatchApiGateway extends Construct {
    private readonly api;
    private readonly stage;
    private readonly watchful;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: WatchApiGatewayProps);
    private createCallGraphWidget;
    private createCacheGraphWidget;
    private createLatencyGraphWidget;
    private createApiGatewayMetric;
}
/**
 * An operation (path and method) worth monitoring.
 *
 * @stability stable
 */
export interface WatchedOperation {
    /**
     * The HTTP method for the operation (GET, POST, ...).
     *
     * @stability stable
     */
    readonly httpMethod: string;
    /**
     * The REST API path for this operation (/, /resource/{id}, ...).
     *
     * @stability stable
     */
    readonly resourcePath: string;
}
