import { IAspect, IConstruct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface WatchfulAspectProps {
    /**
     * Automatically watch API Gateway APIs in the scope.
     *
     * @default true
     * @stability stable
     */
    readonly apiGateway?: boolean;
    /**
     * Automatically watch all Amazon DynamoDB tables in the scope.
     *
     * @default true
     * @stability stable
     */
    readonly dynamodb?: boolean;
    /**
     * Automatically watch AWS Lambda functions in the scope.
     *
     * @default true
     * @stability stable
     */
    readonly lambda?: boolean;
    /**
     * Automatically watch RDS Aurora clusters in the scope.
     *
     * @default true
     * @stability stable
     */
    readonly rdsaurora?: boolean;
    /**
     * Automatically watch ApplicationLoadBalanced Fargate Ecs Services in the scope (using ECS Pattern).
     *
     * @default true
     * @stability stable
     */
    readonly fargateecs?: boolean;
    /**
     * Automatically watch ApplicationLoadBalanced EC2 Ecs Services in the scope (using ECS Pattern).
     *
     * @default true
     * @stability stable
     */
    readonly ec2ecs?: boolean;
}
/**
 * A CDK aspect that can automatically watch all resources within a scope.
 *
 * @stability stable
 */
export declare class WatchfulAspect implements IAspect {
    private readonly watchful;
    private readonly props;
    /**
     * Defines a watchful aspect.
     *
     * @param watchful The watchful to add those resources to.
     * @param props Options.
     * @stability stable
     */
    constructor(watchful: Watchful, props?: WatchfulAspectProps);
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node: IConstruct): void;
}
import { Watchful } from './watchful';
