"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchfulAspect = void 0;
const apigw = require("@aws-cdk/aws-apigateway");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const ecs_patterns = require("@aws-cdk/aws-ecs-patterns");
const lambda = require("@aws-cdk/aws-lambda");
const rds = require("@aws-cdk/aws-rds");
/**
 * A CDK aspect that can automatically watch all resources within a scope.
 *
 * @stability stable
 */
class WatchfulAspect {
    /**
     * Defines a watchful aspect.
     *
     * @param watchful The watchful to add those resources to.
     * @param props Options.
     * @stability stable
     */
    constructor(watchful, props = {}) {
        this.watchful = watchful;
        this.props = props;
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        const watchApiGateway = this.props.apiGateway === undefined ? true : this.props.apiGateway;
        const watchDynamo = this.props.dynamodb === undefined ? true : this.props.dynamodb;
        const watchLambda = this.props.lambda === undefined ? true : this.props.lambda;
        const watchRdsAuroraCluster = this.props.rdsaurora === undefined ? true : this.props.rdsaurora;
        const watchFargateEcs = this.props.fargateecs === undefined ? true : this.props.fargateecs;
        const watchEc2Ecs = this.props.ec2ecs === undefined ? true : this.props.ec2ecs;
        if (watchApiGateway && node instanceof apigw.RestApi) {
            this.watchful.watchApiGateway(node.node.path, node);
        }
        if (watchDynamo && node instanceof dynamodb.Table) {
            this.watchful.watchDynamoTable(node.node.path, node);
        }
        if (watchLambda && node instanceof lambda.Function) {
            this.watchful.watchLambdaFunction(node.node.path, node);
        }
        if (watchRdsAuroraCluster && node instanceof rds.DatabaseCluster) {
            this.watchful.watchRdsAuroraCluster(node.node.path, node);
        }
        if (watchFargateEcs && node instanceof ecs_patterns.ApplicationLoadBalancedFargateService) {
            this.watchful.watchFargateEcs(node.node.path, node.service, node.targetGroup);
        }
        if (watchEc2Ecs && node instanceof ecs_patterns.ApplicationLoadBalancedEc2Service) {
            this.watchful.watchEc2Ecs(node.node.path, node.service, node.targetGroup);
        }
    }
}
exports.WatchfulAspect = WatchfulAspect;
//# sourceMappingURL=data:application/json;base64,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