import * as dynamodb from '@aws-cdk/aws-dynamodb';
import { Construct } from '@aws-cdk/core';
import { IWatchful } from './api';
/**
 * @stability stable
 */
export interface WatchDynamoTableOptions {
    /**
     * Threshold for read capacity alarm (percentage).
     *
     * @default 80
     * @stability stable
     */
    readonly readCapacityThresholdPercent?: number;
    /**
     * Threshold for read capacity alarm (percentage).
     *
     * @default 80
     * @stability stable
     */
    readonly writeCapacityThresholdPercent?: number;
}
/**
 * @stability stable
 */
export interface WatchDynamoTableProps extends WatchDynamoTableOptions {
    /**
     * @stability stable
     */
    readonly title: string;
    /**
     * @stability stable
     */
    readonly watchful: IWatchful;
    /**
     * @stability stable
     */
    readonly table: dynamodb.Table;
}
/**
 * @stability stable
 */
export declare class WatchDynamoTable extends Construct {
    private readonly watchful;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: WatchDynamoTableProps);
    /**
     * Create widgets for tables with billingMode=PROVISIONED
     * Include alarms when capacity is over 80% of the provisioned value
     */
    private createWidgetsForProvisionedTable;
    /**
     * Create widgets for tables with billingMode=PAY_PER_REQUEST
     * Include consumed capacity metrics
     */
    private createWidgetsForPayPerRequestTable;
    private createDynamoCapacityGraph;
    private createDynamoPPRGraph;
    private createDynamoCapacityAlarm;
}
