from datetime import timedelta
from typing import overload

NANOSECONDS_PER_TICK = ...
TICKS_PER_MICROSECOND = ...

TICKS_PER_MILLISECOND = ...
TICKS_PER_SECOND = ...
TICKS_PER_MINUTE = ...
TICKS_PER_HOUR = ...
TICKS_PER_DAY = ...

MICROSECONDS_PER_MILLISECOND = ...
MICROSECONDS_PER_SECOND = ...
MICROSECONDS_PER_MINUTE = ...
MICROSECONDS_PER_HOUR = ...
MICROSECONDS_PER_DAY = ...

MILLISECONDS_PER_SECOND = ...
MILLISECONDS_PER_MINUTE = ...
MILLISECONDS_PER_HOUR = ...
MILLISECONDS_PER_DAY = ...

SECONDS_PER_MINUTE = ...
SECONDS_PER_HOUR = ...
SECONDS_PER_DAY = ...

MINUTES_PER_HOUR = ...
MINUTES_PER_DAY = ...

HOURS_PER_DAY = ...

MIN_TICKS = ...
MAX_TICKS = ...

MIN_MICROSECONDS = ...
MAX_MICROSECONDS = ...

MIN_MILLISECONDS = ...
MAX_MILLISECONDS = ...

MIN_SECONDS = ...
MAX_SECONDS = ...

MIN_MINUTES = ...
MAX_MINUTES = ...

MIN_HOURS = ...
MAX_HOURS = ...

MIN_DAYS = ...
MAX_DAYS = ...

TICKS_PER_TENTH_SECOND = ...

class timespan:
    @overload
    def __init__(self, a: int) -> None:
        """ticks"""
        ...

    @overload
    def __init__(self, a: tuple[int, int, int]) -> None:
        """(hour, minute, second)"""
        ...

    @overload
    def __init__(self, a: tuple[int, int, int, int]) -> None:
        """(day, hour, minute, second)"""
        ...

    @overload
    def __init__(self, a: tuple[int, int, int, int, int]) -> None:
        """(day, hour, minute, second, millisecond)"""
        ...

    @overload
    def __init__(self, a: tuple[int, int, int, int, int, int]) -> None:
        """(day, hour, minute, second, millisecond, microsecond)"""
        ...

    def __init__(self, a) -> None: ...
    @property
    def sign(self) -> int: ...
    @property
    def ticks(self) -> int: ...
    @property
    def days(self) -> int: ...
    @property
    def hours(self) -> int: ...
    @property
    def minutes(self) -> int: ...
    @property
    def seconds(self) -> int: ...
    @property
    def milliseconds(self) -> int: ...
    @property
    def microseconds(self) -> int: ...
    @property
    def nanoseconds(self) -> int: ...
    @property
    def total_days(self) -> float: ...
    @property
    def total_hours(self) -> float: ...
    @property
    def total_minutes(self) -> float: ...
    @property
    def total_seconds(self) -> float: ...
    @property
    def total_milliseconds(self) -> float: ...
    @property
    def total_microseconds(self) -> float: ...
    @property
    def total_nanoseconds(self) -> float: ...
    def to_timedelta(self) -> timedelta: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __abs__(self) -> "timespan": ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __format__(self, format_spec: str) -> str: ...
    def __pos__(self) -> "timespan": ...
    def __neg__(self) -> "timespan": ...
    def __add__(self, ts: "timespan") -> "timespan": ...
    def __sub__(self, ts: "timespan") -> "timespan": ...
    def __mul__(self, f: float) -> "timespan": ...
    def __rmul__(self, f: float) -> "timespan": ...
    def __truediv__(self, d: float) -> "timespan": ...

MIN = ...
MAX = ...

def time_to_ticks(
    days: int = 0,
    hours: int = 0,
    minutes: int = 0,
    seconds: int = 0,
    milliseconds: int = 0,
    microseconds: int = 0,
) -> int: ...
def interval_from_float_ticks(t: float) -> timespan: ...
def interval(v: float, s: float) -> timespan: ...
def parse(text: str) -> timespan: ...
def try_parse(text: str) -> tuple[bool, timespan | None]: ...
def from_ticks(ticks: int) -> timespan: ...
def from_days(days: float) -> timespan: ...
def from_hours(hours: float) -> timespan: ...
def from_minutes(minutes: float) -> timespan: ...
def from_seconds(seconds: float) -> timespan: ...
def from_milliseconds(milliseconds: float) -> timespan: ...
def from_microseconds(microseconds: float) -> timespan: ...
def from_nanoseconds(nanoseconds: float) -> timespan: ...
def from_timedelta(td: timedelta) -> timespan: ...
