"""Increase pipeline spec field length [0e4735b23577].

Revision ID: 0e4735b23577
Revises: 0.41.0
Create Date: 2023-07-17 11:34:43.392096

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects.mysql import MEDIUMTEXT

# revision identifiers, used by Alembic.
revision = "0e4735b23577"
down_revision = "0.41.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("pipeline", schema=None) as batch_op:
        batch_op.alter_column(
            "spec",
            existing_type=sa.TEXT(),
            type_=sa.String(length=16777215).with_variant(MEDIUMTEXT, "mysql"),
            existing_nullable=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("pipeline", schema=None) as batch_op:
        batch_op.alter_column(
            "spec",
            existing_type=sa.String(length=16777215),
            type_=sa.TEXT(),
            existing_nullable=False,
        )

    # ### end Alembic commands ###
