"""add stack and component spec paths to stack and components [e1d66d91a099].

Revision ID: e1d66d91a099
Revises: 0.43.0
Create Date: 2023-07-27 16:07:57.115142

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "e1d66d91a099"
down_revision = "0.43.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("stack", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "stack_spec_path",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )

    with op.batch_alter_table("stack_component", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "component_spec_path",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("stack_component", schema=None) as batch_op:
        batch_op.drop_column("component_spec_path")

    with op.batch_alter_table("stack", schema=None) as batch_op:
        batch_op.drop_column("stack_spec_path")

    # ### end Alembic commands ###
