"""Increase length of artifact table sources [f49904a80aa7].

Revision ID: f49904a80aa7
Revises: d26471b6fe8f
Create Date: 2023-03-15 12:52:58.367624

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "f49904a80aa7"
down_revision = "d26471b6fe8f"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("artifact", schema=None) as batch_op:
        batch_op.alter_column(
            "materializer",
            existing_type=sa.VARCHAR(length=255),
            type_=sa.TEXT(),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "data_type",
            existing_type=sa.VARCHAR(length=255),
            type_=sa.TEXT(),
            existing_nullable=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("artifact", schema=None) as batch_op:
        batch_op.alter_column(
            "data_type",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=255),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "materializer",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=255),
            existing_nullable=False,
        )

    # ### end Alembic commands ###
