# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from data_repo_client.api_client import ApiClient
from data_repo_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DuosApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def retrieve_duos_firecloud_group(self, duos_id, **kwargs):  # noqa: E501
        """retrieve_duos_firecloud_group  # noqa: E501

        Returns a DUOS Firecloud group managed by TDR. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_duos_firecloud_group(duos_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str duos_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DuosFirecloudGroupModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_duos_firecloud_group_with_http_info(duos_id, **kwargs)  # noqa: E501

    def retrieve_duos_firecloud_group_with_http_info(self, duos_id, **kwargs):  # noqa: E501
        """retrieve_duos_firecloud_group  # noqa: E501

        Returns a DUOS Firecloud group managed by TDR. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_duos_firecloud_group_with_http_info(duos_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str duos_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DuosFirecloudGroupModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'duos_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_duos_firecloud_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'duos_id' is set
        if self.api_client.client_side_validation and ('duos_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['duos_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `duos_id` when calling `retrieve_duos_firecloud_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'duos_id' in local_var_params:
            path_params['duosId'] = local_var_params['duos_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth', 'oidc']  # noqa: E501

        return self.api_client.call_api(
            '/api/repository/v1/duos/{duosId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DuosFirecloudGroupModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_duos_firecloud_groups(self, **kwargs):  # noqa: E501
        """retrieve_duos_firecloud_groups  # noqa: E501

        Returns a list of all DUOS Firecloud groups managed by TDR. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_duos_firecloud_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DuosFirecloudGroupModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_duos_firecloud_groups_with_http_info(**kwargs)  # noqa: E501

    def retrieve_duos_firecloud_groups_with_http_info(self, **kwargs):  # noqa: E501
        """retrieve_duos_firecloud_groups  # noqa: E501

        Returns a list of all DUOS Firecloud groups managed by TDR. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_duos_firecloud_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DuosFirecloudGroupModel], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_duos_firecloud_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth', 'oidc']  # noqa: E501

        return self.api_client.call_api(
            '/api/repository/v1/duos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DuosFirecloudGroupModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sync_duos_dataset_authorized_users(self, duos_id, **kwargs):  # noqa: E501
        """sync_duos_dataset_authorized_users  # noqa: E501

        Sync the DUOS dataset's authorized users as members of their corresponding TDR-managed Firecloud group.  Any snapshots linked to the DUOS dataset have this Firecloud group as a reader, which means its members are also snapshot readers. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync_duos_dataset_authorized_users(duos_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str duos_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DuosFirecloudGroupModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sync_duos_dataset_authorized_users_with_http_info(duos_id, **kwargs)  # noqa: E501

    def sync_duos_dataset_authorized_users_with_http_info(self, duos_id, **kwargs):  # noqa: E501
        """sync_duos_dataset_authorized_users  # noqa: E501

        Sync the DUOS dataset's authorized users as members of their corresponding TDR-managed Firecloud group.  Any snapshots linked to the DUOS dataset have this Firecloud group as a reader, which means its members are also snapshot readers. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync_duos_dataset_authorized_users_with_http_info(duos_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str duos_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DuosFirecloudGroupModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'duos_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sync_duos_dataset_authorized_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'duos_id' is set
        if self.api_client.client_side_validation and ('duos_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['duos_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `duos_id` when calling `sync_duos_dataset_authorized_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'duos_id' in local_var_params:
            path_params['duosId'] = local_var_params['duos_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth', 'oidc']  # noqa: E501

        return self.api_client.call_api(
            '/api/repository/v1/duos/{duosId}/syncAuthorizedUsers', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DuosFirecloudGroupModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sync_duos_datasets_authorized_users(self, **kwargs):  # noqa: E501
        """sync_duos_datasets_authorized_users  # noqa: E501

        Sync the members of all TDR-managed DUOS Firecloud groups with the authorized users of their corresponding DUOS datasets.  Any snapshots linked to a DUOS dataset have its Firecloud group as a reader, which means its members are also snapshot readers. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync_duos_datasets_authorized_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DuosFirecloudGroupsSyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sync_duos_datasets_authorized_users_with_http_info(**kwargs)  # noqa: E501

    def sync_duos_datasets_authorized_users_with_http_info(self, **kwargs):  # noqa: E501
        """sync_duos_datasets_authorized_users  # noqa: E501

        Sync the members of all TDR-managed DUOS Firecloud groups with the authorized users of their corresponding DUOS datasets.  Any snapshots linked to a DUOS dataset have its Firecloud group as a reader, which means its members are also snapshot readers. NOTE: This is an experimental feature and its response body may change.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync_duos_datasets_authorized_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DuosFirecloudGroupsSyncResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sync_duos_datasets_authorized_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['googleoauth', 'oidc']  # noqa: E501

        return self.api_client.call_api(
            '/api/repository/v1/duos/syncAuthorizedUsers', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DuosFirecloudGroupsSyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
