# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class JobModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'description': 'str',
        'job_status': 'str',
        'status_code': 'int',
        'submitted': 'str',
        'completed': 'str',
        'class_name': 'str'
    }

    attribute_map = {
        'id': 'id',
        'description': 'description',
        'job_status': 'job_status',
        'status_code': 'status_code',
        'submitted': 'submitted',
        'completed': 'completed',
        'class_name': 'class_name'
    }

    def __init__(self, id=None, description=None, job_status=None, status_code=None, submitted=None, completed=None, class_name=None, local_vars_configuration=None):  # noqa: E501
        """JobModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._description = None
        self._job_status = None
        self._status_code = None
        self._submitted = None
        self._completed = None
        self._class_name = None
        self.discriminator = None

        self.id = id
        if description is not None:
            self.description = description
        self.job_status = job_status
        self.status_code = status_code
        if submitted is not None:
            self.submitted = submitted
        if completed is not None:
            self.completed = completed
        if class_name is not None:
            self.class_name = class_name

    @property
    def id(self):
        """Gets the id of this JobModel.  # noqa: E501

        Unique identifier for a flights, jobs, etc.   # noqa: E501

        :return: The id of this JobModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobModel.

        Unique identifier for a flights, jobs, etc.   # noqa: E501

        :param id: The id of this JobModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and not re.search(r'[A-za-z0-9_\\-]{22}', id)):  # noqa: E501
            raise ValueError(r"Invalid value for `id`, must be a follow pattern or equal to `/[A-za-z0-9_\\-]{22}/`")  # noqa: E501

        self._id = id

    @property
    def description(self):
        """Gets the description of this JobModel.  # noqa: E501

        Description of the job's flight from description flight input parameter  # noqa: E501

        :return: The description of this JobModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this JobModel.

        Description of the job's flight from description flight input parameter  # noqa: E501

        :param description: The description of this JobModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def job_status(self):
        """Gets the job_status of this JobModel.  # noqa: E501

        Status of job  # noqa: E501

        :return: The job_status of this JobModel.  # noqa: E501
        :rtype: str
        """
        return self._job_status

    @job_status.setter
    def job_status(self, job_status):
        """Sets the job_status of this JobModel.

        Status of job  # noqa: E501

        :param job_status: The job_status of this JobModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and job_status is None:  # noqa: E501
            raise ValueError("Invalid value for `job_status`, must not be `None`")  # noqa: E501
        allowed_values = ["running", "succeeded", "failed"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and job_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `job_status` ({0}), must be one of {1}"  # noqa: E501
                .format(job_status, allowed_values)
            )

        self._job_status = job_status

    @property
    def status_code(self):
        """Gets the status_code of this JobModel.  # noqa: E501

        HTTP code  # noqa: E501

        :return: The status_code of this JobModel.  # noqa: E501
        :rtype: int
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """Sets the status_code of this JobModel.

        HTTP code  # noqa: E501

        :param status_code: The status_code of this JobModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and status_code is None:  # noqa: E501
            raise ValueError("Invalid value for `status_code`, must not be `None`")  # noqa: E501

        self._status_code = status_code

    @property
    def submitted(self):
        """Gets the submitted of this JobModel.  # noqa: E501

        Timestamp when the flight was created  # noqa: E501

        :return: The submitted of this JobModel.  # noqa: E501
        :rtype: str
        """
        return self._submitted

    @submitted.setter
    def submitted(self, submitted):
        """Sets the submitted of this JobModel.

        Timestamp when the flight was created  # noqa: E501

        :param submitted: The submitted of this JobModel.  # noqa: E501
        :type: str
        """

        self._submitted = submitted

    @property
    def completed(self):
        """Gets the completed of this JobModel.  # noqa: E501

        Timestamp when the flight was completed; not present if not complete  # noqa: E501

        :return: The completed of this JobModel.  # noqa: E501
        :rtype: str
        """
        return self._completed

    @completed.setter
    def completed(self, completed):
        """Sets the completed of this JobModel.

        Timestamp when the flight was completed; not present if not complete  # noqa: E501

        :param completed: The completed of this JobModel.  # noqa: E501
        :type: str
        """

        self._completed = completed

    @property
    def class_name(self):
        """Gets the class_name of this JobModel.  # noqa: E501

        Class name of the flight  # noqa: E501

        :return: The class_name of this JobModel.  # noqa: E501
        :rtype: str
        """
        return self._class_name

    @class_name.setter
    def class_name(self, class_name):
        """Sets the class_name of this JobModel.

        Class name of the flight  # noqa: E501

        :param class_name: The class_name of this JobModel.  # noqa: E501
        :type: str
        """

        self._class_name = class_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobModel):
            return True

        return self.to_dict() != other.to_dict()
