# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotSourceModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dataset': 'DatasetSummaryModel',
        'dataset_properties': 'object',
        'asset': 'str'
    }

    attribute_map = {
        'dataset': 'dataset',
        'dataset_properties': 'datasetProperties',
        'asset': 'asset'
    }

    def __init__(self, dataset=None, dataset_properties=None, asset=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotSourceModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._dataset = None
        self._dataset_properties = None
        self._asset = None
        self.discriminator = None

        self.dataset = dataset
        if dataset_properties is not None:
            self.dataset_properties = dataset_properties
        if asset is not None:
            self.asset = asset

    @property
    def dataset(self):
        """Gets the dataset of this SnapshotSourceModel.  # noqa: E501


        :return: The dataset of this SnapshotSourceModel.  # noqa: E501
        :rtype: DatasetSummaryModel
        """
        return self._dataset

    @dataset.setter
    def dataset(self, dataset):
        """Sets the dataset of this SnapshotSourceModel.


        :param dataset: The dataset of this SnapshotSourceModel.  # noqa: E501
        :type: DatasetSummaryModel
        """
        if self.local_vars_configuration.client_side_validation and dataset is None:  # noqa: E501
            raise ValueError("Invalid value for `dataset`, must not be `None`")  # noqa: E501

        self._dataset = dataset

    @property
    def dataset_properties(self):
        """Gets the dataset_properties of this SnapshotSourceModel.  # noqa: E501

        Additional JSON metadata about the source dataset  # noqa: E501

        :return: The dataset_properties of this SnapshotSourceModel.  # noqa: E501
        :rtype: object
        """
        return self._dataset_properties

    @dataset_properties.setter
    def dataset_properties(self, dataset_properties):
        """Sets the dataset_properties of this SnapshotSourceModel.

        Additional JSON metadata about the source dataset  # noqa: E501

        :param dataset_properties: The dataset_properties of this SnapshotSourceModel.  # noqa: E501
        :type: object
        """

        self._dataset_properties = dataset_properties

    @property
    def asset(self):
        """Gets the asset of this SnapshotSourceModel.  # noqa: E501

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The asset of this SnapshotSourceModel.  # noqa: E501
        :rtype: str
        """
        return self._asset

    @asset.setter
    def asset(self, asset):
        """Sets the asset of this SnapshotSourceModel.

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :param asset: The asset of this SnapshotSourceModel.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                asset is not None and len(asset) > 63):
            raise ValueError("Invalid value for `asset`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                asset is not None and len(asset) < 1):
            raise ValueError("Invalid value for `asset`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                asset is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', asset)):  # noqa: E501
            raise ValueError(r"Invalid value for `asset`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._asset = asset

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotSourceModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotSourceModel):
            return True

        return self.to_dict() != other.to_dict()
